/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.factory.impl;

import io.github.ibuildthecloud.gdapi.factory.SchemaFactory;
import io.github.ibuildthecloud.gdapi.model.Schema;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSchemaFactory
implements SchemaFactory {
    @Override
    public String getSchemaName(Class<?> clz) {
        Schema schema = this.getSchema(clz);
        return schema == null ? null : schema.getId();
    }

    @Override
    public String getSchemaName(String type) {
        Schema schema = this.getSchema(type);
        return schema == null ? null : schema.getId();
    }

    @Override
    public List<String> getSchemaNames(Class<?> clz) {
        ArrayList<String> result = new ArrayList<String>();
        this.getNames(this.getSchema(clz), result);
        return result;
    }

    protected void getNames(Schema schema, List<String> result) {
        if (schema == null) {
            return;
        }
        result.add(schema.getId());
        for (String child : schema.getChildren()) {
            Schema childSchema = this.getSchema(child);
            this.getNames(childSchema, result);
        }
    }

    @Override
    public Class<?> getSchemaClass(Class<?> type) {
        Schema schema = this.getSchema(type);
        return schema == null ? null : this.getSchemaClass(schema.getId());
    }

    @Override
    public String getPluralName(String type) {
        Schema schema = this.getSchema(type);
        return schema == null ? null : schema.getPluralName();
    }

    @Override
    public String getSingularName(String type) {
        return this.getSchemaName(type);
    }

    @Override
    public boolean typeStringMatches(Class<?> clz, String type) {
        if (type == null || clz == null) {
            return false;
        }
        Schema schema = this.getSchema(clz);
        if (schema == null) {
            return false;
        }
        return schema == this.getSchema(type);
    }

    @Override
    public Class<?> getSchemaClass(String type, boolean resolveParent) {
        Schema schema;
        Class<?> clz = this.getSchemaClass(type);
        if (clz == null && resolveParent && (schema = this.getSchema(type)) != null && schema.getParent() != null) {
            return this.getSchemaClass(schema.getParent(), true);
        }
        return clz;
    }

    @Override
    public String getBaseType(String type) {
        Schema schema = this.getSchema(type);
        if (schema == null) {
            return null;
        }
        while (schema.getParent() != null) {
            Schema parent = this.getSchema(schema.getParent());
            if (parent == null) {
                return null;
            }
            schema = parent;
        }
        return schema.getId();
    }
}

