/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.request.handler;

import io.github.ibuildthecloud.gdapi.exception.ClientVisibleException;
import io.github.ibuildthecloud.gdapi.model.ApiError;
import io.github.ibuildthecloud.gdapi.model.impl.ErrorImpl;
import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.request.handler.ApiRequestHandler;
import io.github.ibuildthecloud.gdapi.util.ExceptionUtils;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler
implements ApiRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandler.class);
    Properties standardErrorCodes;
    String messageLocation;
    String messageLocationOverride;
    boolean throwUnknownErrors = false;

    @Override
    public void handle(ApiRequest request) throws IOException {
    }

    @Override
    public boolean handleException(ApiRequest apiRequest, Throwable t) throws IOException, ServletException {
        ApiError error = this.getError(apiRequest, t);
        if (error != null) {
            apiRequest.setResponseCode(error.getStatus());
            apiRequest.setResponseObject(error);
            return true;
        }
        return false;
    }

    protected ApiError getError(ApiRequest apiRequest, Throwable t) throws IOException, ServletException {
        if (t instanceof ClientVisibleException) {
            return this.getError(apiRequest, (ClientVisibleException)t);
        }
        return this.getUnknownError(apiRequest, t);
    }

    protected ApiError getError(ApiRequest apiRequest, ClientVisibleException e) {
        if (e.getApiError() != null) {
            return e.getApiError();
        }
        ErrorImpl errorImpl = new ErrorImpl(e);
        return this.populateError(errorImpl, apiRequest.getLocale());
    }

    protected ApiError getUnknownError(ApiRequest apiRequest, Throwable t) throws IOException, ServletException {
        log.error("Exception in API for request [{}]", (Object)apiRequest, (Object)t);
        if (this.throwUnknownErrors) {
            ExceptionUtils.rethrowRuntime(t);
            ExceptionUtils.rethrow(t, IOException.class);
            ExceptionUtils.rethrow(t, ServletException.class);
            throw new ServletException(t);
        }
        return this.populateError(new ErrorImpl(500), apiRequest.getLocale());
    }

    protected ApiError populateError(ErrorImpl error, Locale locale) {
        if (error.getCode() == null) {
            if (this.standardErrorCodes != null) {
                error.setCode(this.standardErrorCodes.getProperty(Integer.toString(error.getStatus())));
            }
            if (error.getCode() == null) {
                error.setCode(Integer.toString(error.getStatus()));
            }
        }
        if (error.getMessage() == null) {
            error.setMessage(error.getCode());
        }
        error.setMessage(this.getMessage(error.getMessage(), locale));
        error.setDetail(this.getMessage(error.getDetail(), locale));
        return error;
    }

    protected String getMessage(String messageCode, Locale locale) {
        if (messageCode == null) {
            return messageCode;
        }
        String message = null;
        message = this.getLocalizedMessage(this.messageLocationOverride, messageCode, locale);
        if (message == null) {
            message = this.getLocalizedMessage(this.messageLocation, messageCode, locale);
        }
        return message == null ? messageCode : message;
    }

    protected String getLocalizedMessage(String location, String messageCode, Locale locale) {
        if (locale == null || location == null) {
            return null;
        }
        ResourceBundle bundle = ResourceBundle.getBundle(this.messageLocation, locale);
        if (bundle != null) {
            try {
                return bundle.getString(messageCode);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return null;
    }

    public Properties getStandardErrorCodes() {
        return this.standardErrorCodes;
    }

    public void setStandardErrorCodes(Properties standardErrorCodes) {
        this.standardErrorCodes = standardErrorCodes;
    }

    public String getMessageLocation() {
        return this.messageLocation;
    }

    public void setMessageLocation(String messageLocation) {
        this.messageLocation = messageLocation;
    }

    public String getMessageLocationOverride() {
        return this.messageLocationOverride;
    }

    public void setMessageLocationOverride(String messageLocationOverride) {
        this.messageLocationOverride = messageLocationOverride;
    }

    public boolean isThrowUnknownErrors() {
        return this.throwUnknownErrors;
    }

    public void setThrowUnknownErrors(boolean throwUnknownErrors) {
        this.throwUnknownErrors = throwUnknownErrors;
    }
}

