/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.request.handler;

import io.github.ibuildthecloud.gdapi.exception.ClientVisibleException;
import io.github.ibuildthecloud.gdapi.json.JsonMapper;
import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.request.handler.AbstractApiRequestHandler;
import io.github.ibuildthecloud.gdapi.request.handler.ApiRequestHandler;
import io.github.ibuildthecloud.gdapi.util.RequestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;

public class BodyParserRequestHandler
extends AbstractApiRequestHandler
implements ApiRequestHandler {
    JsonMapper jsonMarshaller;
    Set<Class<?>> allowedTypes;

    @Override
    public void handle(ApiRequest request) throws IOException {
        Object obj = this.getObject(request);
        request.setRequestObject(this.merge(obj, request));
    }

    protected Object getObject(ApiRequest request) throws IOException {
        if (!RequestUtils.mayHaveBody(request.getMethod())) {
            return null;
        }
        if (!this.shouldBeParsed(request)) {
            return null;
        }
        InputStream is = request.getInputStream();
        if (is == null) {
            return null;
        }
        byte[] content = IOUtils.toByteArray((InputStream)is);
        if (content.length == 0) {
            return null;
        }
        try {
            Object body = this.jsonMarshaller.readValue(content);
            if (this.isAllowedType(body)) {
                return body;
            }
        }
        catch (IOException e) {
            throw new ClientVisibleException(400, "InvalidBodyContent");
        }
        return null;
    }

    protected boolean isAllowedType(Object obj) {
        if (obj == null) {
            return false;
        }
        boolean accepted = false;
        for (Class<?> type : this.allowedTypes) {
            if (!type.isAssignableFrom(obj.getClass())) continue;
            accepted = true;
            break;
        }
        return accepted;
    }

    protected boolean shouldBeParsed(ApiRequest request) {
        return true;
    }

    protected Object merge(Object body, ApiRequest request) {
        if (body instanceof Map) {
            Map map = (Map)body;
            return this.mergeMap(map, request);
        }
        if (body instanceof List) {
            List list = (List)body;
            ArrayList<Object> result = new ArrayList<Object>(list.size());
            for (Object object : list) {
                if (!this.isAllowedType(object)) continue;
                result.add(this.merge(object, request));
            }
            return result;
        }
        return this.mergeMap(null, request);
    }

    protected Map<String, Object> mergeMap(Map<String, Object> overlay, ApiRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : request.getRequestParams().entrySet()) {
            result.put(entry.getKey(), RequestUtils.makeSingularIfCan(entry.getValue()));
        }
        if (overlay != null) {
            for (Map.Entry<String, Object> entry : overlay.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    @PostConstruct
    public void init() {
        if (this.allowedTypes == null) {
            this.allowedTypes = new HashSet();
            this.allowedTypes.add(Map.class);
            this.allowedTypes.add(List.class);
        }
    }

    public JsonMapper getJsonMarshaller() {
        return this.jsonMarshaller;
    }

    @Inject
    public void setJsonMarshaller(JsonMapper jsonMarshaller) {
        this.jsonMarshaller = jsonMarshaller;
    }

    public Set<Class<?>> getAllowedTypes() {
        return this.allowedTypes;
    }

    public void setAllowedTypes(Set<Class<?>> allowedTypes) {
        this.allowedTypes = allowedTypes;
    }
}

