/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.request.resource.impl;

import io.github.ibuildthecloud.gdapi.factory.SchemaFactory;
import io.github.ibuildthecloud.gdapi.request.resource.ResourceManager;
import io.github.ibuildthecloud.gdapi.request.resource.ResourceManagerFilter;
import io.github.ibuildthecloud.gdapi.request.resource.ResourceManagerLocator;
import io.github.ibuildthecloud.gdapi.request.resource.impl.AbstractResourceManagerLocatorImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class ResourceManagerLocatorImpl
extends AbstractResourceManagerLocatorImpl
implements ResourceManagerLocator {
    List<ResourceManager> resourceManagers;
    List<ResourceManagerFilter> resourceManagerFilters;
    ResourceManager defaultResourceManager;
    Map<String, List<ResourceManagerFilter>> resourceManagerFiltersByType = new LinkedHashMap<String, List<ResourceManagerFilter>>();
    Map<String, ResourceManager> resourceManagersByType = new LinkedHashMap<String, ResourceManager>();
    SchemaFactory schemaFactory;

    @PostConstruct
    public void init() {
        String type;
        this.resourceManagersByType.clear();
        this.resourceManagerFiltersByType.clear();
        for (ResourceManager rm : this.resourceManagers) {
            for (String string : rm.getTypes()) {
                this.resourceManagersByType.put(string, rm);
            }
            for (Class<?> clazz : rm.getTypeClasses()) {
                type = this.schemaFactory.getSchemaName(clazz);
                if (type == null) continue;
                this.resourceManagersByType.put(type, rm);
            }
        }
        for (ResourceManagerFilter filter : this.resourceManagerFilters) {
            for (String string : filter.getTypes()) {
                this.add(this.resourceManagerFiltersByType, string, filter);
            }
            for (Class<?> clazz : filter.getTypeClasses()) {
                type = this.schemaFactory.getSchemaName(clazz);
                if (type == null) continue;
                this.add(this.resourceManagerFiltersByType, type, filter);
            }
        }
    }

    @Override
    protected void add(Map<String, List<ResourceManagerFilter>> filters, String key, ResourceManagerFilter filter) {
        List<ResourceManagerFilter> list = filters.get(key);
        if (list == null) {
            list = new ArrayList<ResourceManagerFilter>();
            filters.put(key, list);
        }
        list.add(filter);
    }

    @Override
    protected ResourceManager getResourceManagersByTypeInternal(String type) {
        return this.resourceManagersByType.get(type);
    }

    @Override
    protected List<ResourceManagerFilter> getResourceManagerFiltersByTypeInternal(String type) {
        return this.resourceManagerFiltersByType.get(type);
    }

    @Override
    public ResourceManager getDefaultResourceManager() {
        return this.defaultResourceManager;
    }

    public void setDefaultResourceManager(ResourceManager defaultResourceManager) {
        this.defaultResourceManager = defaultResourceManager;
    }

    public List<ResourceManagerFilter> getResourceManagerFilters() {
        return this.resourceManagerFilters;
    }

    @Inject
    public void setResourceManagerFilters(List<ResourceManagerFilter> resourceManagerFilters) {
        this.resourceManagerFilters = resourceManagerFilters;
    }

    public List<ResourceManager> getResourceManagers() {
        return this.resourceManagers;
    }

    @Inject
    public void setResourceManagers(List<ResourceManager> resourceManagers) {
        this.resourceManagers = resourceManagers;
    }

    public SchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    @Inject
    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }
}

