/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.fsm;

import io.github.interacto.error.ErrorCatcher;
import io.github.interacto.fsm.CancelFSMException;
import io.github.interacto.fsm.InputState;
import io.github.interacto.fsm.OutputState;
import io.github.interacto.fsm.Transition;
import io.github.interacto.interaction.ThreadService;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.LongSupplier;

public class TimeoutTransition<E>
extends Transition<E> {
    public static final String TIMEOUT_THREAD_NAME_BASE = "malai-timeout-transition-";
    private final LongSupplier timeoutDuration;
    private Thread timeoutThread;
    private boolean timeouted;

    public TimeoutTransition(OutputState<E> srcState, InputState<E> tgtState, LongSupplier timeout) {
        super(srcState, tgtState);
        if (timeout == null) {
            throw new IllegalArgumentException();
        }
        this.timeoutDuration = timeout;
        this.timeouted = false;
    }

    public void startTimeout() {
        long time = this.timeoutDuration.getAsLong();
        if (this.timeoutThread == null) {
            if (time <= 0L) {
                this.src.getFSM().onTimeout();
                return;
            }
            this.timeoutThread = new Thread(() -> {
                try {
                    ThreadService.getInstance().sleep(time);
                    this.timeouted = true;
                    this.src.getFSM().onTimeout();
                }
                catch (InterruptedException ex) {
                    ThreadService.getInstance().currentThread().interrupt();
                }
            }, TIMEOUT_THREAD_NAME_BASE + System.currentTimeMillis());
            this.timeoutThread.setUncaughtExceptionHandler((th, ex) -> ErrorCatcher.getInstance().reportError(ex));
            this.timeoutThread.start();
        }
    }

    public void stopTimeout() {
        if (this.timeoutThread != null) {
            this.timeoutThread.interrupt();
            this.timeoutThread = null;
        }
    }

    @Override
    protected boolean accept(E event) {
        return this.timeouted;
    }

    @Override
    protected boolean isGuardOK(E event) {
        return this.timeouted;
    }

    @Override
    public Optional<InputState<E>> execute(E event) throws CancelFSMException {
        try {
            if (this.accept(event) && this.isGuardOK(event)) {
                this.src.exit();
                this.action(event);
                this.tgt.enter();
                this.timeouted = false;
                return Optional.of(this.tgt);
            }
            return Optional.empty();
        }
        catch (CancelFSMException ex) {
            this.timeouted = false;
            throw ex;
        }
    }

    @Override
    public Set<Object> getAcceptedEvents() {
        return Collections.emptySet();
    }
}

