/*
 * Decompiled with CFR 0.152.
 */
package RenderMultipoints;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.IPointConversion;
import ArmyC2.C2SD.Utilities.PointConversion;
import ArmyC2.C2SD.Utilities.RendererException;
import JavaLineArray.POINT2;
import JavaLineArray.Shape2;
import JavaLineArray.lineutility;
import JavaTacticalRenderer.TGLight;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public final class clsUtility {
    private static final String _className = "clsUtility";

    protected static Point POINT2ToPoint(POINT2 pt2) {
        Point pt = new Point();
        pt.x = (int)pt2.x;
        pt.y = (int)pt2.y;
        return pt;
    }

    protected static POINT2 PointToPOINT2(Point pt) {
        POINT2 pt2 = new POINT2((double)pt.x, (double)pt.y);
        return pt2;
    }

    protected static Point2D.Double POINT2ToPoint2D(POINT2 pt2) {
        Point2D.Double pt2d = new Point2D.Double(pt2.x, pt2.y);
        return pt2d;
    }

    protected static ArrayList<POINT2> Points2DToPOINT2(ArrayList<Point2D> pts2d) {
        ArrayList<POINT2> pts = new ArrayList<POINT2>();
        POINT2 pt = null;
        for (int j = 0; j < pts2d.size(); ++j) {
            pt = new POINT2(pts2d.get(j).getX(), pts2d.get(j).getY());
            pts.add(pt);
        }
        return pts;
    }

    protected static POINT2 Point2DToPOINT2(Point2D.Double pt2d) {
        POINT2 pt2 = new POINT2(pt2d.x, pt2d.y);
        return pt2;
    }

    protected static boolean addModifiersBeforeClipping(TGLight tg) {
        boolean result = false;
        int linetype = tg.get_LineType();
        switch (linetype) {
            case 21700000: 
            case 21710000: 
            case 21800000: 
            case 22121000: 
            case 22122000: 
            case 22123000: 
            case 22124000: 
            case 22125000: 
            case 22221000: 
            case 22222000: 
            case 22222001: 
            case 22223000: 
            case 22224000: 
            case 22224001: 
            case 22225000: 
            case 22320000: 
            case 22330000: 
            case 22421000: 
            case 22422000: 
            case 22522100: 
            case 22523000: 
            case 22524000: 
            case 22525000: 
            case 22526000: 
            case 22527000: 
            case 22528000: 
            case 22613000: 
            case 23163000: 
            case 23410000: 
            case 24210000: 
            case 24211000: 
            case 24220000: 
            case 24225000: 
            case 24230000: 
            case 24240000: 
            case 24250000: 
            case 24260000: 
            case 25211000: 
            case 25212000: 
            case 25221000: 
            case 25222000: 
            case 25223000: 
            case 25224000: 
            case 25225000: 
            case 26400000: 
            case 26410000: 
            case 26420000: 
            case 26430000: 
            case 26440000: 
            case 211800000: 
            case 212000000: 
            case 212210000: 
            case 212210001: 
            case 212220000: 
            case 212220001: 
            case 212230000: 
            case 212230001: 
            case 212400000: 
            case 212410000: {
                result = true;
                break;
            }
        }
        if (JavaTacticalRenderer.clsUtility.isClosedPolygon((int)linetype)) {
            result = true;
        }
        return result;
    }

    protected static void FilterPoints(TGLight tg) {
        try {
            int lineType = tg.get_LineType();
            double minSpikeDistance = 0.0;
            switch (lineType) {
                case 22122000: 
                case 22134000: 
                case 23131100: 
                case 23131200: 
                case 23132000: 
                case 23330000: 
                case 23350000: {
                    minSpikeDistance = 25.0;
                    break;
                }
                case 22123000: 
                case 22624000: 
                case 23111000: 
                case 23111001: 
                case 23112000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23134000: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: {
                    minSpikeDistance = 35.0;
                    break;
                }
                case 31131000: 
                case 31131100: 
                case 31131200: 
                case 31131300: {
                    minSpikeDistance = 60.0;
                    break;
                }
                case 31133000: 
                case 31133100: 
                case 31134000: 
                case 31134100: {
                    minSpikeDistance = 60.0;
                    break;
                }
                case 31134200: 
                case 31134300: {
                    minSpikeDistance = 60.0;
                    break;
                }
                case 31132200: 
                case 31132300: 
                case 31133200: {
                    minSpikeDistance = 60.0;
                    break;
                }
                case 31132000: 
                case 31132100: {
                    minSpikeDistance = 40.0;
                    break;
                }
                case 31142000: 
                case 32156000: 
                case 32162000: 
                case 32164000: {
                    minSpikeDistance = 35.0;
                    break;
                }
                default: {
                    return;
                }
            }
            int j = 0;
            double dist = 0.0;
            ArrayList pts = new ArrayList();
            ArrayList ptsGeo = new ArrayList();
            pts.add(tg.Pixels.get(0));
            ptsGeo.add(tg.LatLongs.get(0));
            POINT2 lastGoodPt = (POINT2)tg.Pixels.get(0);
            POINT2 currentPt = null;
            POINT2 currentPtGeo = null;
            boolean foundGoodPt = false;
            block15: for (j = 1; j < tg.Pixels.size(); ++j) {
                currentPt = (POINT2)tg.Pixels.get(j);
                currentPtGeo = (POINT2)tg.LatLongs.get(j);
                if (currentPt.style == -1) {
                    lastGoodPt = currentPt;
                    pts.add(currentPt);
                    ptsGeo.add(currentPtGeo);
                    foundGoodPt = true;
                    currentPt.style = 0;
                    continue;
                }
                dist = lineutility.CalcDistanceDouble((POINT2)lastGoodPt, (POINT2)currentPt);
                switch (lineType) {
                    case 22123000: {
                        if (dist > minSpikeDistance) {
                            lastGoodPt = currentPt;
                            pts.add(currentPt);
                            ptsGeo.add(currentPtGeo);
                            foundGoodPt = true;
                            continue block15;
                        }
                        if (j != tg.Pixels.size() - 1) continue block15;
                        pts.set(pts.size() - 1, currentPt);
                        ptsGeo.set(ptsGeo.size() - 1, currentPtGeo);
                        continue block15;
                    }
                    default: {
                        if (!(dist > minSpikeDistance) && j != tg.Pixels.size() - 1) continue block15;
                        lastGoodPt = currentPt;
                        pts.add(currentPt);
                        ptsGeo.add(currentPtGeo);
                        foundGoodPt = true;
                    }
                }
            }
            if (foundGoodPt) {
                tg.Pixels = pts;
                tg.LatLongs = ptsGeo;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"FilterPoints", (Exception)new RendererException("Failed inside FilterPoints", (Throwable)exc));
        }
    }

    protected static ArrayList<POINT2> PixelsToLatLong(ArrayList<POINT2> pts, IPointConversion converter) {
        int j = 0;
        POINT2 pt = null;
        POINT2 ptGeo = null;
        ArrayList<POINT2> ptsGeo = new ArrayList<POINT2>();
        for (j = 0; j < pts.size(); ++j) {
            pt = pts.get(j);
            ptGeo = clsUtility.PointPixelsToLatLong(pt, converter);
            ptsGeo.add(ptGeo);
        }
        return ptsGeo;
    }

    protected static boolean isAutoshape(TGLight tg) {
        try {
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 12000000: 
                case 13000000: 
                case 13000001: 
                case 13000002: 
                case 14000000: 
                case 15000002: 
                case 15000003: 
                case 15000004: 
                case 21100000: 
                case 21200000: 
                case 21300000: 
                case 21400000: 
                case 21500000: 
                case 21600000: 
                case 21800000: 
                case 22139000: 
                case 22221000: 
                case 22222000: 
                case 22222001: 
                case 22223000: 
                case 22224000: 
                case 22224001: 
                case 22225000: 
                case 22310000: 
                case 22422000: 
                case 22524000: 
                case 22533000: 
                case 22534000: 
                case 22611000: 
                case 23157000: 
                case 23163000: 
                case 23171000: 
                case 23172000: 
                case 23173000: 
                case 23174000: 
                case 23191000: 
                case 23192000: 
                case 23193000: 
                case 23194000: 
                case 23211000: 
                case 23212000: 
                case 23213000: 
                case 23221000: 
                case 23222000: 
                case 23223000: 
                case 23224000: 
                case 23225000: 
                case 23226000: 
                case 23227000: 
                case 23340000: 
                case 23410000: 
                case 24211000: 
                case 24250000: 
                case 24260000: 
                case 25211000: 
                case 25212000: 
                case 26400000: 
                case 26410000: 
                case 26420000: 
                case 26430000: 
                case 26440000: 
                case 211000000: 
                case 211100000: 
                case 211200000: 
                case 211210000: 
                case 211400000: 
                case 211600000: 
                case 211700000: 
                case 211800000: 
                case 211900000: 
                case 212000000: 
                case 212100000: 
                case 212210000: 
                case 212210001: 
                case 212220000: 
                case 212220001: 
                case 212230000: 
                case 212230001: 
                case 212300000: 
                case 212300001: 
                case 212400000: 
                case 212410000: 
                case 212500000: 
                case 212600000: 
                case 231100000: {
                    return true;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"isAutoshape", (Exception)new RendererException("Failed inside isAutoshape", (Throwable)exc));
        }
        return false;
    }

    protected static ArrayList<POINT2> LatLongToPixels(ArrayList<POINT2> pts, IPointConversion converter) {
        int j = 0;
        POINT2 pt = null;
        POINT2 ptPixels = null;
        ArrayList<POINT2> ptsPixels = new ArrayList<POINT2>();
        for (j = 0; j < pts.size(); ++j) {
            pt = pts.get(j);
            ptPixels = clsUtility.PointLatLongToPixels(pt, converter);
            ptsPixels.add(ptPixels);
        }
        return ptsPixels;
    }

    private static POINT2 PointLatLongToPixels(POINT2 ptLatLong, IPointConversion converter) {
        POINT2 pt2 = new POINT2();
        try {
            Point2D.Double pt2d = new Point2D.Double(ptLatLong.x, ptLatLong.y);
            Point2D pt2d2 = converter.GeoToPixels((Point2D)pt2d);
            pt2 = new POINT2(pt2d2.getX(), pt2d2.getY());
            pt2.style = ptLatLong.style;
        }
        catch (Exception e) {
            JavaTacticalRenderer.clsUtility.WriteFile((String)"Error in clsUtility.PointLatLongToPixels");
        }
        return pt2;
    }

    protected static void FilterAXADPoints(TGLight tg, IPointConversion converter) {
        try {
            int lineType = tg.get_LineType();
            switch (lineType) {
                case 21700000: 
                case 21710000: 
                case 22320000: 
                case 22521100: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: {
                    break;
                }
                default: {
                    return;
                }
            }
            int j = 0;
            ArrayList pts = new ArrayList();
            ArrayList ptsGeo = new ArrayList();
            POINT2 pt0 = (POINT2)tg.Pixels.get(0);
            POINT2 pt1 = (POINT2)tg.Pixels.get(1);
            Point pt = new Point((int)pt1.x, (int)pt1.y);
            Point2D pt1Geo2d = converter.PixelsToGeo((Point2D)pt);
            POINT2 pt1geo = new POINT2(pt1Geo2d.getX(), pt1Geo2d.getY());
            POINT2 ptj = null;
            POINT2 ptjGeo = null;
            POINT2 controlPt = (POINT2)tg.Pixels.get(tg.Pixels.size() - 1);
            POINT2 pt0Relative = lineutility.PointRelativeToLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt0, (POINT2)controlPt);
            double relativeDist = lineutility.CalcDistanceDouble((POINT2)pt0Relative, (POINT2)controlPt);
            relativeDist += 5.0;
            double pt0pt1dist = lineutility.CalcDistanceDouble((POINT2)pt0, (POINT2)pt1);
            boolean foundGoodPoint = false;
            if (relativeDist > pt0pt1dist) {
                pts.add(pt0);
                pt = new Point((int)pt0.x, (int)pt0.y);
                pt1Geo2d = converter.PixelsToGeo((Point2D)pt);
                pt1geo = new POINT2(pt1Geo2d.getX(), pt1Geo2d.getY());
                ptsGeo.add(pt1geo);
                pt1 = lineutility.ExtendAlongLineDouble((POINT2)pt0, (POINT2)pt1, (double)relativeDist);
                pts.add(pt1);
                pt = new Point((int)pt1.x, (int)pt1.y);
                pt1Geo2d = converter.PixelsToGeo((Point2D)pt);
                pt1geo = new POINT2(pt1Geo2d.getX(), pt1Geo2d.getY());
                ptsGeo.add(pt1geo);
            } else {
                foundGoodPoint = true;
                pts = tg.Pixels;
                ptsGeo = tg.LatLongs;
            }
            if (!foundGoodPoint) {
                for (j = 2; j < tg.Pixels.size() - 1; ++j) {
                    ptj = (POINT2)tg.Pixels.get(j);
                    ptjGeo = (POINT2)tg.LatLongs.get(j);
                    if (foundGoodPoint) {
                        pts.add(ptj);
                        ptsGeo.add(ptjGeo);
                        continue;
                    }
                    pt0pt1dist = lineutility.CalcDistanceDouble((POINT2)pt0, (POINT2)ptj);
                    if (relativeDist > pt0pt1dist) continue;
                    pts.add(ptj);
                    ptsGeo.add(ptjGeo);
                    foundGoodPoint = true;
                }
                pts.add(controlPt);
                pt = new Point((int)controlPt.x, (int)controlPt.y);
                pt1Geo2d = converter.PixelsToGeo((Point2D)pt);
                pt1geo = new POINT2(pt1Geo2d.getX(), pt1Geo2d.getY());
                ptsGeo.add(pt1geo);
            }
            POINT2 lastGoodPt = (POINT2)pts.get(1);
            POINT2 currentPt = null;
            POINT2 currentPtGeo = null;
            double dist = 0.0;
            tg.Pixels = new ArrayList();
            tg.LatLongs = new ArrayList();
            for (j = 0; j < 2; ++j) {
                tg.Pixels.add(pts.get(j));
                tg.LatLongs.add(ptsGeo.get(j));
            }
            for (j = 2; j < pts.size() - 1; ++j) {
                currentPt = (POINT2)pts.get(j);
                currentPtGeo = (POINT2)ptsGeo.get(j);
                dist = lineutility.CalcDistanceDouble((POINT2)currentPt, (POINT2)lastGoodPt);
                if (!(dist > 5.0)) continue;
                lastGoodPt = currentPt;
                tg.Pixels.add(currentPt);
                tg.LatLongs.add(currentPtGeo);
            }
            tg.Pixels.add(pts.get(pts.size() - 1));
            tg.LatLongs.add(ptsGeo.get(ptsGeo.size() - 1));
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"FilterAXADPoints", (Exception)new RendererException("Failed inside FilterAXADPoints", (Throwable)exc));
        }
    }

    protected static void RemoveDuplicatePoints(TGLight tg) {
        try {
            switch (tg.get_LineType()) {
                case 22221000: 
                case 22222000: 
                case 22223000: 
                case 22224000: 
                case 22225000: {
                    break;
                }
                default: {
                    if (!clsUtility.isAutoshape(tg)) break;
                    return;
                }
            }
            switch (tg.get_LineType()) {
                case 21700000: 
                case 21710000: 
                case 22320000: 
                case 22521100: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: {
                    return;
                }
                case 22121000: 
                case 25221000: 
                case 25222000: {
                    String[] strs;
                    String strH = tg.get_H();
                    if (strH == null || strH.isEmpty() || (strs = strH.split(",")).length <= 1) break;
                    return;
                }
            }
            int linetype = tg.get_LineType();
            if (JavaTacticalRenderer.clsUtility.IsChange1Area((int)linetype, null)) {
                return;
            }
            int minSize = 2;
            if (JavaTacticalRenderer.clsUtility.isClosedPolygon((int)tg.get_LineType())) {
                minSize = 3;
            }
            POINT2 ptCurrent = null;
            POINT2 ptLast = null;
            for (int j = 1; j < tg.Pixels.size(); ++j) {
                ptLast = new POINT2((POINT2)tg.Pixels.get(j - 1));
                ptCurrent = new POINT2((POINT2)tg.Pixels.get(j));
                if (!(Math.abs(ptCurrent.x - ptLast.x) < 0.5) || !(Math.abs(ptCurrent.y - ptLast.y) < 0.5) || tg.Pixels.size() <= minSize) continue;
                tg.Pixels.remove(j);
                tg.LatLongs.remove(j);
                j = 1;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"FilterVerticalSegments", (Exception)new RendererException("Failed inside FilterVerticalSegments", (Throwable)exc));
        }
    }

    public static IPointConversion BestFitConverter(ArrayList<POINT2> latLongs) {
        PointConversion converter = null;
        try {
            int j = 0;
            int pixelWidth = 1000;
            int pixelHeight = 1000;
            double geoTop = Double.MIN_NORMAL;
            double geoBottom = Double.MAX_VALUE;
            double geoLeft = Double.MAX_VALUE;
            double geoRight = Double.MIN_NORMAL;
            for (j = 0; j < latLongs.size(); ++j) {
                if (latLongs.get((int)j).y > geoTop) {
                    geoTop = latLongs.get((int)j).y;
                }
                if (latLongs.get((int)j).y < geoBottom) {
                    geoBottom = latLongs.get((int)j).y;
                }
                if (latLongs.get((int)j).x > geoRight) {
                    geoRight = latLongs.get((int)j).x;
                }
                if (!(latLongs.get((int)j).x < geoLeft)) continue;
                geoLeft = latLongs.get((int)j).x;
            }
            converter = new PointConversion(pixelWidth, pixelHeight, geoTop, geoLeft, geoBottom, geoRight);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"BestFitConverter", (Exception)new RendererException("Failed inside BestFitConverter", (Throwable)exc));
        }
        return converter;
    }

    protected static POINT2 PointPixelsToLatLong(POINT2 ptPixels, IPointConversion converter) {
        POINT2 pt2 = new POINT2();
        try {
            Point2D pt2d = new Point2D.Double(ptPixels.x, ptPixels.y);
            pt2d = converter.PixelsToGeo(pt2d);
            pt2 = new POINT2(pt2d.getX(), pt2d.getY());
            pt2.style = ptPixels.style;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"PointPixelsToLatLong", (Exception)new RendererException("Could not convert point to geo", (Throwable)exc));
        }
        return pt2;
    }

    protected static void ResolveDummyShapes(TGLight tg, ArrayList<Shape2> shapes) {
        try {
            int shapeStyle = -1;
            Shape2 shape = null;
            switch (tg.get_LineType()) {
                case 0x222248: {
                    String status = tg.get_Status();
                    for (int j = 0; j < shapes.size(); ++j) {
                        shape = shapes.get(j);
                        shapeStyle = shape.get_Style();
                        if (shapeStyle != 1) {
                            shape.setFillColor(tg.get_FillColor());
                            shape.set_Fillstyle(tg.get_FillStyle());
                            continue;
                        }
                        if (j != 0 || !status.equalsIgnoreCase("A")) continue;
                        shape.setFillColor(tg.get_FillColor());
                        shape.set_Fillstyle(tg.get_FillStyle());
                    }
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"ResolveDummyShapes", (Exception)new RendererException("ResolveDummyShapes", (Throwable)exc));
        }
    }

    protected static Rectangle2D getMBR(ArrayList<Point2D> clipBounds) {
        Rectangle2D.Double rect = null;
        try {
            double ymax;
            double xmax;
            int j = 0;
            Point2D pt = null;
            double xmin = xmax = clipBounds.get(0).getX();
            double ymin = ymax = clipBounds.get(0).getY();
            for (j = 0; j < clipBounds.size(); ++j) {
                pt = clipBounds.get(j);
                if (pt.getX() < xmin) {
                    xmin = pt.getX();
                }
                if (pt.getX() > xmax) {
                    xmax = pt.getX();
                }
                if (pt.getY() <= ymin) {
                    ymin = pt.getY();
                }
                if (!(pt.getY() > ymax)) continue;
                ymax = pt.getY();
            }
            rect = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"AddBoundaryPointsForLines", (Exception)new RendererException("Failed inside AddBoundaryPointsForLines", (Throwable)exc));
        }
        return rect;
    }
}

