/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.ImagePropertiesSize;
import io.github.pod4dev.libpodj.model.Platform;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ImageProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONTAINERS = "Containers";
    @SerializedName(value="Containers")
    private List<String> containers = new ArrayList<String>();
    public static final String SERIALIZED_NAME_PLATFORM = "Platform";
    @SerializedName(value="Platform")
    private Platform platform;
    public static final String SERIALIZED_NAME_SIZE = "Size";
    @SerializedName(value="Size")
    private ImagePropertiesSize size;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ImageProperties containers(List<String> containers) {
        this.containers = containers;
        return this;
    }

    public ImageProperties addContainersItem(String containersItem) {
        if (this.containers == null) {
            this.containers = new ArrayList<String>();
        }
        this.containers.add(containersItem);
        return this;
    }

    @Nonnull
    @NotNull
    public List<String> getContainers() {
        return this.containers;
    }

    public void setContainers(List<String> containers) {
        this.containers = containers;
    }

    public ImageProperties platform(Platform platform) {
        this.platform = platform;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public ImageProperties size(ImagePropertiesSize size) {
        this.size = size;
        return this;
    }

    @Nullable
    @Valid
    public ImagePropertiesSize getSize() {
        return this.size;
    }

    public void setSize(ImagePropertiesSize size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageProperties imageProperties = (ImageProperties)o;
        return Objects.equals(this.containers, imageProperties.containers) && Objects.equals(this.platform, imageProperties.platform) && Objects.equals(this.size, imageProperties.size);
    }

    public int hashCode() {
        return Objects.hash(this.containers, this.platform, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageProperties {\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ImageProperties is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ImageProperties` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONTAINERS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_CONTAINERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Containers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINERS).toString()));
        }
        Platform.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PLATFORM));
        if (jsonObj.get(SERIALIZED_NAME_SIZE) != null && !jsonObj.get(SERIALIZED_NAME_SIZE).isJsonNull()) {
            ImagePropertiesSize.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SIZE));
        }
    }

    public static ImageProperties fromJson(String jsonString) throws IOException {
        return (ImageProperties)JSON.getGson().fromJson(jsonString, ImageProperties.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_PLATFORM);
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CONTAINERS);
        openapiRequiredFields.add(SERIALIZED_NAME_PLATFORM);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ImageProperties.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ImageProperties.class));
            return new TypeAdapter<ImageProperties>(this){

                public void write(JsonWriter out, ImageProperties value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ImageProperties read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ImageProperties.validateJsonElement(jsonElement);
                    return (ImageProperties)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

