/*
 * Decompiled with CFR 0.152.
 */
package com.splitit;

import com.splitit.sdk.model.Error;
import com.splitit.sdk.model.ResponseHeader;
import java.util.List;
import java.util.Map;

public class ApiException
extends Exception {
    private int code = 0;
    private Map<String, List<String>> responseHeaders = null;
    private String responseBody = null;
    private ResponseHeader responseHeader = null;

    public ApiException() {
    }

    public ApiException(String message, ResponseHeader responseHeader) {
        super(message);
        this.responseHeader = responseHeader;
    }

    public static ApiException fromResponseHeader(ResponseHeader responseHeader) {
        List<Error> errors = responseHeader.getErrors();
        if (errors == null || errors.size() == 0) {
            return new ApiException("Unknown API error has ocurred, invocation was unsuccessfull.", responseHeader);
        }
        return new ApiException(errors.get(0).getErrorCode() + ": " + errors.get(0).getMessage(), responseHeader);
    }

    public ApiException(Throwable throwable) {
        super(throwable);
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        super(message, throwable);
        this.code = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public ApiException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, null, code, responseHeaders, responseBody);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders) {
        this(message, throwable, code, responseHeaders, null);
    }

    public ApiException(int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(null, null, code, responseHeaders, responseBody);
    }

    public ApiException(int code, String message) {
        super(message);
        this.code = code;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public int getCode() {
        return this.code;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }
}

