/*
 * Decompiled with CFR 0.152.
 */
package io.github.unknowncoder56.javaslc;

import com.google.gson.JsonObject;
import io.github.unknowncoder56.javaslc.Bot;
import io.github.unknowncoder56.javaslc.User;
import java.util.concurrent.CompletableFuture;

public class MessageContext {
    private final String content;
    private final User owner;
    private final long serverId;
    private final Bot bot;

    public MessageContext(JsonObject message, long serverId, Bot bot) {
        this.content = message.get("content").getAsString();
        this.owner = new User(message.get("owner").getAsLong(), bot.getErrorListener());
        this.serverId = serverId;
        this.bot = bot;
    }

    public CompletableFuture<Void> send(String message) {
        return this.bot.send(message, this.serverId);
    }

    public String getContent() {
        return this.content;
    }

    public User getOwner() {
        return this.owner;
    }

    public long getServerId() {
        return this.serverId;
    }

    public Bot getBot() {
        return this.bot;
    }
}

