/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.jooby.Context;
import io.jooby.FileUpload;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.internal.openapi.ClassSource;
import io.jooby.internal.openapi.ConflictiveSetter;
import io.jooby.internal.openapi.ModelConverterExt;
import io.jooby.internal.openapi.SchemaRef;
import io.jooby.internal.openapi.TypeFactory;
import io.jooby.internal.openapi.asm.ClassReader;
import io.jooby.internal.openapi.asm.ClassVisitor;
import io.jooby.internal.openapi.asm.Type;
import io.jooby.internal.openapi.asm.tree.AbstractInsnNode;
import io.jooby.internal.openapi.asm.tree.ClassNode;
import io.jooby.internal.openapi.asm.tree.MethodNode;
import io.jooby.internal.openapi.asm.util.ASMifier;
import io.jooby.internal.openapi.asm.util.TraceClassVisitor;
import io.jooby.internal.openapi.asm.util.TraceMethodVisitor;
import io.jooby.openapi.DebugOption;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ParserContext {
    private String mainClass;
    private final ModelConverters converters;
    private final Type router;
    private final Map<Type, ClassNode> nodes;
    private final ClassSource source;
    private final Set<Object> instructions = new HashSet<Object>();
    private final Set<DebugOption> debug;
    private final ConcurrentMap<String, SchemaRef> schemas = new ConcurrentHashMap<String, SchemaRef>();

    public ParserContext(ClassSource source, Type router, Set<DebugOption> debug) {
        this(source, new HashMap<Type, ClassNode>(), router, debug);
    }

    private ParserContext(ClassSource source, Map<Type, ClassNode> nodes, Type router, Set<DebugOption> debug) {
        this.router = router;
        this.source = source;
        this.debug = Optional.ofNullable(debug).orElse(Collections.emptySet());
        this.nodes = nodes;
        List<ObjectMapper> mappers = Arrays.asList(Json.mapper(), Yaml.mapper());
        this.jacksonModules(source.getClassLoader(), mappers);
        this.converters = ModelConverters.getInstance();
        mappers.stream().map(ModelConverterExt::new).forEach(arg_0 -> ((ModelConverters)this.converters).addConverter(arg_0));
    }

    private void jacksonModules(ClassLoader classLoader, List<ObjectMapper> mappers) {
        ArrayList<Object> modules = new ArrayList<Object>(2);
        try {
            Class<?> kotlinModuleClass = classLoader.loadClass("com.fasterxml.jackson.module.kotlin.KotlinModule");
            Constructor<?> constructor = kotlinModuleClass.getDeclaredConstructor(new Class[0]);
            Module module2 = (Module)constructor.newInstance(new Object[0]);
            modules.add(module2);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        modules.add(new SimpleModule("jooby-openapi"){

            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.insertAnnotationIntrospector((AnnotationIntrospector)new ConflictiveSetter());
            }
        });
        modules.add(new Jdk8Module());
        modules.forEach(module -> mappers.forEach(mapper -> mapper.registerModule(module)));
        mappers.stream().forEach(mapper -> mapper.setTypeFactory(mapper.getTypeFactory().withClassLoader(classLoader)));
    }

    public Collection<Schema> schemas() {
        return this.schemas.values().stream().map(ref -> ref.schema).collect(Collectors.toList());
    }

    public Schema schema(Class type) {
        if (this.isVoid(type.getName())) {
            return null;
        }
        if (type == String.class) {
            return new StringSchema();
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return new IntegerSchema().minimum(BigDecimal.valueOf(-128L)).maximum(BigDecimal.valueOf(127L));
        }
        if (type == Character.class || type == Character.TYPE) {
            return new StringSchema().minLength(Integer.valueOf(0)).maxLength(Integer.valueOf(1));
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return new BooleanSchema();
        }
        if (type == Short.class || type == Short.TYPE) {
            return new IntegerSchema().minimum(BigDecimal.valueOf(-32768L)).maximum(BigDecimal.valueOf(32767L));
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new IntegerSchema();
        }
        if (type == Long.class || type == Long.TYPE) {
            return new IntegerSchema().format("int64");
        }
        if (type == Float.class || type == Float.TYPE) {
            return new NumberSchema().format("float");
        }
        if (type == Double.class || type == Double.TYPE) {
            return new NumberSchema().format("double");
        }
        if (Set.class.isAssignableFrom(type)) {
            return new ArraySchema().uniqueItems(Boolean.valueOf(true));
        }
        if (Collection.class.isAssignableFrom(type)) {
            return new ArraySchema();
        }
        if (File.class.isAssignableFrom(type) || Path.class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type)) {
            return new BinarySchema();
        }
        if (FileUpload.class == type) {
            return new FileSchema();
        }
        if (Reader.class.isAssignableFrom(type)) {
            return new StringSchema();
        }
        if (byte[].class == type || ByteBuffer.class == type) {
            return new ByteArraySchema();
        }
        if (UUID.class == type) {
            return new UUIDSchema();
        }
        if (URI.class == type || URL.class == type) {
            return new StringSchema().format(type.getSimpleName().toLowerCase());
        }
        if (BigInteger.class == type) {
            return new IntegerSchema().format(null);
        }
        if (BigDecimal.class == type) {
            return new NumberSchema().format(null);
        }
        if (Date.class == type || LocalDate.class == type) {
            return new DateSchema();
        }
        if (LocalDateTime.class == type || Instant.class == type || OffsetDateTime.class == type || ZonedDateTime.class == type) {
            return new DateTimeSchema();
        }
        if (Period.class == type || Duration.class == type || Currency.class == type || Locale.class == type) {
            return new StringSchema();
        }
        if (type.isArray()) {
            return new ArraySchema();
        }
        if (Map.class.isAssignableFrom(type)) {
            return new MapSchema();
        }
        if (type == Object.class || type == Void.TYPE || type == Void.class) {
            return new ObjectSchema();
        }
        if (type.isEnum()) {
            StringSchema schema = new StringSchema();
            EnumSet.allOf(type).forEach(e -> schema.addEnumItem(((Enum)e).name()));
            return schema;
        }
        SchemaRef schemaRef = (SchemaRef)this.schemas.get(type.getName());
        if (schemaRef == null) {
            ResolvedSchema resolvedSchema = this.converters.readAllAsResolvedSchema((java.lang.reflect.Type)type);
            if (resolvedSchema.schema == null) {
                throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
            }
            schemaRef = new SchemaRef(resolvedSchema.schema, RefUtils.constructRef((String)resolvedSchema.schema.getName()));
            this.schemas.put(type.getName(), schemaRef);
            if (resolvedSchema.referencedSchemas != null) {
                for (Map.Entry e2 : resolvedSchema.referencedSchemas.entrySet()) {
                    if (((String)e2.getKey()).equals(schemaRef.schema.getName())) continue;
                    SchemaRef dependency = new SchemaRef((Schema)e2.getValue(), RefUtils.constructRef((String)((Schema)e2.getValue()).getName()));
                    this.schemas.putIfAbsent((String)e2.getKey(), dependency);
                }
            }
        }
        return schemaRef.toSchema();
    }

    public Optional<SchemaRef> schemaRef(String type) {
        return Optional.ofNullable((SchemaRef)this.schemas.get(type));
    }

    public Schema schema(Type type) {
        if (this.isArray(type)) {
            return this.schema(type.getInternalName());
        }
        return this.schema(type.getClassName());
    }

    private boolean isArray(Type type) {
        return type.getDescriptor().charAt(0) == '[';
    }

    public Schema schema(String type) {
        if (this.isVoid(type)) {
            return null;
        }
        SchemaRef schema = (SchemaRef)this.schemas.get(type);
        if (schema != null) {
            return schema.toSchema();
        }
        String json = "{\"type\":\"" + type + "\"}";
        try {
            TypeLiteral literal = (TypeLiteral)Json.mapper().readValue(json, TypeLiteral.class);
            return this.schema(literal.type);
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    private Schema schema(JavaType type) {
        if (type.isArrayType() && type.getContentType().hasRawClass(Byte.TYPE)) {
            return new ByteArraySchema();
        }
        if (type.isCollectionLikeType() || type.isArrayType()) {
            ArraySchema array = new ArraySchema();
            Optional.ofNullable(this.schema(type.getContentType())).ifPresent(arg_0 -> ((ArraySchema)array).setItems(arg_0));
            return array;
        }
        if (type.getRawClass() == Optional.class) {
            List typeParameters = type.getBindings().getTypeParameters();
            return this.schema((JavaType)typeParameters.get(0));
        }
        if (type.isMapLikeType()) {
            MapSchema mapSchema = new MapSchema();
            mapSchema.setAdditionalProperties((Object)this.schema(type.getContentType()));
            return mapSchema;
        }
        return this.schema(type.getRawClass());
    }

    private boolean isVoid(String type) {
        return Context.class.getName().equals(type) || Void.TYPE.getName().equals(type) || Void.class.getName().equals(type) || StatusCode.class.getName().equals(type);
    }

    public ClassNode classNode(Type type) {
        return this.nodes.computeIfAbsent(type, this::newClassNode);
    }

    public MethodNode findMethodNode(Type type, String name) {
        return this.nodes.computeIfAbsent((Type)type, (Function<Type, ClassNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, newClassNode(io.jooby.internal.openapi.asm.Type ), (Lio/jooby/internal/openapi/asm/Type;)Lio/jooby/internal/openapi/asm/tree/ClassNode;)((ParserContext)this)).methods.stream().filter(it -> it.name.equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Method not found: " + String.valueOf(type) + "." + name));
    }

    public ClassNode classNodeOrNull(Type type) {
        try {
            return this.nodes.computeIfAbsent(type, this::newClassNode);
        }
        catch (Exception x) {
            return null;
        }
    }

    public byte[] loadResource(String path) throws IOException {
        return this.source.loadResource(path);
    }

    private ClassNode newClassNode(Type type) {
        ClassReader reader = new ClassReader(this.source.loadClass(type.getClassName()));
        if (this.debug.contains((Object)DebugOption.ALL)) {
            this.debug(reader);
        }
        ClassNode node = this.createClassVisitor(ClassNode::new);
        reader.accept(node, 0);
        return node;
    }

    private void debug(ClassReader reader) {
        ASMifier printer = new ASMifier();
        PrintWriter output = new PrintWriter(System.out);
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, printer, output);
        reader.accept(traceClassVisitor, 0);
    }

    public void debugHandler(MethodNode node) {
        if (this.debug.contains((Object)DebugOption.HANDLER)) {
            this.debug(node);
        }
    }

    private void debug(MethodNode node) {
        System.out.println(Type.getReturnType(node.desc).getClassName() + " " + node.name + " {");
        ASMifier printer = new ASMifier();
        TraceMethodVisitor traceClassVisitor = new TraceMethodVisitor(null, printer);
        node.accept(traceClassVisitor);
        PrintWriter writer = new PrintWriter(System.out);
        printer.print(writer);
        writer.flush();
        System.out.println("}");
    }

    public void debugHandlerLink(MethodNode node) {
        if (this.debug.contains((Object)DebugOption.HANDLER_LINK)) {
            this.debug(node);
        }
    }

    public Type getRouter() {
        return this.router;
    }

    public <T extends ClassVisitor> T createClassVisitor(Function<Integer, T> factory) {
        return (T)((ClassVisitor)factory.apply(589824));
    }

    public boolean isRouter(Type type) {
        return Arrays.asList(this.router, TypeFactory.JOOBY, TypeFactory.KOOBY, TypeFactory.ROUTER, TypeFactory.COROUTINE_ROUTER).contains(type) || (this.router.getClassName() + "Kt").equals(type.getClassName());
    }

    public boolean process(AbstractInsnNode instruction) {
        return this.instructions.add(instruction);
    }

    public ParserContext newContext(Type router) {
        return new ParserContext(this.source, this.nodes, router, this.debug);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public static class TypeLiteral {
        public JavaType type;
    }
}

