/*
 * Decompiled with CFR 0.152.
 */
package io.redskap.lambda.runtime;

import io.redskap.lambda.runtime.RequestHandlerRegistration;
import io.redskap.lambda.runtime.api.LambdaRuntimeHttpClient;
import io.redskap.lambda.runtime.exception.InitializationException;
import io.redskap.lambda.runtime.http.HttpResponse;
import io.redskap.lambda.runtime.internal.RequestHandlerInvoker;
import io.redskap.lambda.runtime.util.EnvironmentVariableResolver;
import io.redskap.lambda.runtime.validation.RequestHandlerRegistrationValidator;
import java.util.Collection;

public class LambdaRuntime {
    private final Collection<RequestHandlerRegistration<?, ?>> handlerRegistrations;
    private final RequestHandlerRegistrationValidator registrationValidator;

    public LambdaRuntime(Collection<RequestHandlerRegistration<?, ?>> handlerRegistrations) {
        this(handlerRegistrations, new RequestHandlerRegistrationValidator());
    }

    public LambdaRuntime(Collection<RequestHandlerRegistration<?, ?>> handlerRegistrations, RequestHandlerRegistrationValidator registrationValidator) {
        this.handlerRegistrations = handlerRegistrations;
        this.registrationValidator = registrationValidator;
    }

    public void run() {
        String runtimeApi = EnvironmentVariableResolver.resolve("AWS_LAMBDA_RUNTIME_API");
        LambdaRuntimeHttpClient runtimeHttpClient = new LambdaRuntimeHttpClient(runtimeApi);
        try {
            RequestHandlerRegistration<?, ?> handlerRegistration = this.findRequestHandlerRegistration();
            this.registrationValidator.validate(handlerRegistration);
            while (true) {
                HttpResponse event = runtimeHttpClient.nextInvocation();
                String requestId = event.getHeaders().getSingleValueHeader("Lambda-Runtime-Aws-Request-Id");
                try {
                    String response = RequestHandlerInvoker.invokeHandler(event, handlerRegistration);
                    runtimeHttpClient.invocationResponse(requestId, response);
                }
                catch (Exception e) {
                    runtimeHttpClient.invocationError(requestId);
                    e.printStackTrace();
                }
            }
        }
        catch (InitializationException e) {
            e.printStackTrace();
            runtimeHttpClient.initializationError(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            runtimeHttpClient.initializationError("Initialization Error");
        }
    }

    private RequestHandlerRegistration<?, ?> findRequestHandlerRegistration() {
        String handlerClassName;
        String handler = EnvironmentVariableResolver.resolve("_HANDLER");
        if (handler != null && (handlerClassName = this.parseHandlerClassName(handler)) != null) {
            for (RequestHandlerRegistration<?, ?> registration : this.handlerRegistrations) {
                if (!handlerClassName.equals(registration.getHandler().getClass().getName())) continue;
                return registration;
            }
        }
        return null;
    }

    protected String parseHandlerClassName(String handler) {
        String[] splitHandler = handler.split("::");
        if (splitHandler.length > 0) {
            return splitHandler[0];
        }
        return null;
    }
}

