/*
 * Decompiled with CFR 0.152.
 */
package io.redskap.lambda.runtime.internal;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import io.redskap.lambda.runtime.http.HttpHeaders;
import io.redskap.lambda.runtime.logging.LambdaLoggerHolder;
import io.redskap.lambda.runtime.util.EnvironmentVariableResolver;
import java.util.Calendar;

public class ContextImpl
implements Context {
    private HttpHeaders headers;

    public ContextImpl(HttpHeaders headers) {
        this.headers = headers;
    }

    public String getAwsRequestId() {
        return this.headers.getSingleValueHeader("Lambda-Runtime-Aws-Request-Id");
    }

    public String getLogGroupName() {
        return EnvironmentVariableResolver.resolve("AWS_LAMBDA_LOG_GROUP_NAME");
    }

    public String getLogStreamName() {
        return EnvironmentVariableResolver.resolve("AWS_LAMBDA_LOG_STREAM_NAME");
    }

    public String getFunctionName() {
        return EnvironmentVariableResolver.resolve("AWS_LAMBDA_FUNCTION_NAME");
    }

    public String getFunctionVersion() {
        return EnvironmentVariableResolver.resolve("AWS_LAMBDA_FUNCTION_VERSION");
    }

    public String getInvokedFunctionArn() {
        return this.headers.getSingleValueHeader("Lambda-Runtime-Invoked-Function-Arn");
    }

    public CognitoIdentity getIdentity() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ClientContext getClientContext() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getRemainingTimeInMillis() {
        String deadlineMsStr = this.headers.getSingleValueHeader("Lambda-Runtime-Deadline-Ms");
        try {
            if (deadlineMsStr != null) {
                long deadlineMs = Long.parseLong(deadlineMsStr);
                long currentMs = this.currentTime();
                long remainingMs = deadlineMs - currentMs;
                return (int)remainingMs;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public int getMemoryLimitInMB() {
        String memoryLimit = EnvironmentVariableResolver.resolve("AWS_LAMBDA_FUNCTION_MEMORY_SIZE");
        if (memoryLimit != null) {
            try {
                return Integer.parseInt(memoryLimit);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public LambdaLogger getLogger() {
        return LambdaLoggerHolder.getLambdaLogger();
    }

    private long currentTime() {
        return Calendar.getInstance().getTimeInMillis();
    }
}

