/*
 * Decompiled with CFR 0.152.
 */
package io.redskap.lambda.runtime.validation;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import io.redskap.lambda.runtime.RequestHandlerRegistration;
import io.redskap.lambda.runtime.exception.InitializationException;
import io.redskap.lambda.runtime.exception.InvalidRequestHandlerRegistrationException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RequestHandlerRegistrationValidator {
    private static final Set<Class<?>> SUPPORTED_CLASSES = new HashSet();
    private final Collection<Class<?>> additionalClasses;

    public RequestHandlerRegistrationValidator() {
        this(Collections.emptyList());
    }

    public RequestHandlerRegistrationValidator(Collection<Class<?>> additionalClasses) {
        this.additionalClasses = additionalClasses;
    }

    public <I, O> void validate(RequestHandlerRegistration<I, O> registration) {
        this.validateNotNull(registration);
        this.validateRegistrationTypes(registration);
    }

    private <I, O> void validateNotNull(RequestHandlerRegistration<I, O> registration) {
        if (registration == null) {
            throw new InitializationException("Handler is not found");
        }
    }

    protected <I, O> void validateRegistrationTypes(RequestHandlerRegistration<I, O> registration) {
        Class<I> requestType = registration.getRequestType();
        if (!SUPPORTED_CLASSES.contains(requestType) && !this.additionalClasses.contains(requestType)) {
            throw new InvalidRequestHandlerRegistrationException("Request type " + requestType.getName() + " is not supported");
        }
        Class<O> responseType = registration.getResponseType();
        if (!SUPPORTED_CLASSES.contains(responseType) && !this.additionalClasses.contains(responseType)) {
            throw new InvalidRequestHandlerRegistrationException("Response type " + responseType.getName() + " is not supported");
        }
    }

    static {
        SUPPORTED_CLASSES.add(String.class);
        SUPPORTED_CLASSES.add(APIGatewayProxyRequestEvent.class);
        SUPPORTED_CLASSES.add(APIGatewayProxyResponseEvent.class);
    }
}

