/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.agent.impl.javaee;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import net.java.trueupdate.agent.core.BasicUpdateAgent;
import net.java.trueupdate.agent.core.UpdateAgentMessageDispatcher;
import net.java.trueupdate.agent.impl.javaee.UpdateAgentBuilderBean;
import net.java.trueupdate.agent.spec.ApplicationParameters;
import net.java.trueupdate.manager.spec.UpdateMessage;
import net.java.trueupdate.shed.Objects;

final class ConfiguredUpdateAgent
extends BasicUpdateAgent {
    private final ApplicationParameters applicationParameters;
    private final ConnectionFactory connectionFactory;
    private final Destination destination;
    private final UpdateAgentMessageDispatcher updateAgentMessageDispatcher;

    ConfiguredUpdateAgent(ApplicationParameters applicationParameters, UpdateAgentBuilderBean b) {
        this.applicationParameters = (ApplicationParameters)Objects.requireNonNull((Object)applicationParameters);
        this.connectionFactory = (ConnectionFactory)Objects.requireNonNull((Object)b.connectionFactory);
        this.destination = (Destination)Objects.requireNonNull((Object)b.destination);
        this.updateAgentMessageDispatcher = (UpdateAgentMessageDispatcher)Objects.requireNonNull((Object)((Object)b.updateAgentMessageDispatcher));
    }

    protected UpdateAgentMessageDispatcher updateAgentMessageDispatcher() {
        return this.updateAgentMessageDispatcher;
    }

    protected ApplicationParameters applicationParameters() {
        return this.applicationParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateMessage send(UpdateMessage message) throws Exception {
        Connection c = this.connectionFactory.createConnection();
        try {
            Session s = c.createSession(false, 1);
            ObjectMessage m = s.createObjectMessage((Serializable)message);
            m.setBooleanProperty("manager", message.type().forManager());
            s.createProducer(this.destination).send((Message)m);
        }
        finally {
            c.close();
        }
        return message;
    }
}

