/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.sample.impl.javaee;

import java.net.URI;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import net.java.trueupdate.agent.spec.ApplicationListener;
import net.java.trueupdate.agent.spec.ApplicationParameters;
import net.java.trueupdate.agent.spec.UpdateAgent;
import net.java.trueupdate.manager.spec.ApplicationDescriptor;
import net.java.trueupdate.manager.spec.UpdateMessage;

@Startup
@Singleton
@DependsOn(value={"UpdateAgentBuilderBean"})
public class UpdateClientBean
extends ApplicationListener {
    private static final Logger logger = Logger.getLogger(UpdateClientBean.class.getName());
    private static ResourceBundle bundle = ResourceBundle.getBundle(UpdateClientBean.class.getName());
    @EJB
    private UpdateAgent.Builder updateAgentBuilder;
    @Resource
    private SessionContext context;

    @PostConstruct
    private void subscribe() {
        this.log(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                UpdateClientBean.this.updateAgent().subscribe();
                return null;
            }
        });
    }

    @PreDestroy
    private void unsubscribe() {
        this.log(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                UpdateClientBean.this.updateAgent().unsubscribe();
                return null;
            }
        });
    }

    @Nullable
    private <V> V log(Callable<V> task) {
        try {
            return task.call();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.context.setRollbackOnly();
            logger.log(Level.WARNING, "Error while processing task.", ex);
            return null;
        }
    }

    private UpdateAgent updateAgent() {
        return ((UpdateAgent.Builder)((ApplicationParameters.Builder)((ApplicationDescriptor.Builder)this.updateAgentBuilder.applicationParameters().applicationListener((ApplicationListener)this).applicationDescriptor().artifactDescriptor().groupId(this.lookupString("groupId")).artifactId(this.lookupString("artifactId")).version(this.lookupString("version")).classifier(this.lookupString("classifier")).extension(this.lookupString("extension")).inject()).currentLocation(this.lookupUri("currentLocation")).inject()).updateLocation(this.lookupUri("updateLocation")).inject()).build();
    }

    private URI lookupUri(String key) {
        return URI.create(this.lookupString(key));
    }

    @Nullable
    private String lookupString(String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public void onSubscriptionSuccessResponse(UpdateMessage message) throws Exception {
        this.logReceived(message);
    }

    public void onSubscriptionFailureResponse(UpdateMessage message) throws Exception {
        this.logReceived(message);
    }

    public void onUpdateNotice(UpdateMessage message) throws Exception {
        this.updateAgent().install(this.logReceived(message).updateVersion());
    }

    public void onInstallationSuccessResponse(UpdateMessage message) throws Exception {
        this.logReceived(message);
    }

    public void onInstallationFailureResponse(UpdateMessage message) throws Exception {
        this.logReceived(message);
    }

    public void onUnsubscriptionSuccessResponse(UpdateMessage message) throws Exception {
        this.logReceived(message);
    }

    public void onUnsubscriptionFailureResponse(UpdateMessage message) throws Exception {
        this.logReceived(message);
    }

    private UpdateMessage logReceived(UpdateMessage message) {
        logger.log(Level.FINE, "Received update message from update manager:\n{0}", message);
        return message;
    }
}

