/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.covid.command.handler;

import com.networknt.config.Config;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.kafka.common.AvroSerializer;
import com.networknt.kafka.common.EventId;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.PortalConfig;
import net.lightapi.portal.command.HybridCommandStartup;
import net.lightapi.portal.covid.CityMapCreatedEvent;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/covid/createCityMap/0.1.0")
public class CreateCityMap
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateCityMap.class);
    private static final PortalConfig config = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);
    private static final String PERMISSION_DENIED = "ERR11620";
    private static final String CITY_REGISTERED = "ERR11621";
    private static final String SEND_MESSAGE_EXCEPTION = "ERR11605";
    AvroSerializer serializer = new AvroSerializer();

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        Map auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        String userId = (String)auditInfo.get("user_id");
        String roles = (String)auditInfo.get("roles");
        if (roles == null || !roles.contains("admin")) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, PERMISSION_DENIED, new Object[]{roles}));
        }
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        String country = (String)map.get("country");
        String province = (String)map.get("province");
        String city = (String)map.get("city");
        double latitude = (Double)map.get("latitude");
        double longitude = (Double)map.get("longitude");
        Integer zoom = (Integer)map.get("zoom");
        Result resultCity = HybridQueryClient.getCity((HttpServerExchange)exchange, (String)country, (String)province, (String)city);
        if (resultCity.isSuccess()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, CITY_REGISTERED, new Object[]{country, province, city}));
        }
        if (resultCity.getError().getStatusCode() != 404) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultCity.getError()));
        }
        Result result = HybridQueryClient.getNonceByUserId((HttpServerExchange)exchange, (String)userId);
        if (result.isSuccess()) {
            EventId eventId = EventId.newBuilder().setId(userId).setNonce(Long.valueOf((String)result.getResult()).longValue()).setTimestamp(System.currentTimeMillis()).build();
            CityMapCreatedEvent event = CityMapCreatedEvent.newBuilder().setEventId(eventId).setHostId(hostId).setCountry(country).setProvince(province).setCity(city).setLatitude(latitude).setLongitude(longitude).setZoom(zoom.intValue()).build();
            byte[] bytes = this.serializer.serialize((Object)event);
            ProducerRecord record = new ProducerRecord(config.getTopic(), (Object)(config.isMultitenancy() ? hostId : userId).getBytes(StandardCharsets.UTF_8), (Object)bytes);
            CountDownLatch latch = new CountDownLatch(1);
            try {
                HybridCommandStartup.producer.send(record, (recordMetadata, e) -> {
                    if (Objects.nonNull(e)) {
                        logger.error("Exception occurred while pushing the event", (Throwable)e);
                    } else {
                        logger.info("Event record pushed successfully. Received Record Metadata is {}", (Object)recordMetadata);
                    }
                    latch.countDown();
                });
                latch.await();
            }
            catch (InterruptedException e2) {
                logger.error("Exception:", (Throwable)e2);
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, SEND_MESSAGE_EXCEPTION, new Object[]{e2.getMessage(), config.isMultitenancy() ? hostId : userId}));
            }
        } else {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, result.getError()));
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, "SUC10200", new Object[0]));
    }
}

