/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.covid.command.handler;

import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.kafka.common.AvroSerializer;
import com.networknt.kafka.common.EventId;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.PortalConfig;
import net.lightapi.portal.command.HybridCommandStartup;
import net.lightapi.portal.covid.CovidEntityUpdatedEvent;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/covid/updateEntity/0.1.0")
public class UpdateEntity
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateEntity.class);
    private static final PortalConfig config = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);
    private static final String PROFILE_LOCATION_INCOMPLETE = "ERR11622";
    private static final String SEND_MESSAGE_EXCEPTION = "ERR11605";
    private static final String CITY_NOT_REGISTERED = "ERR11623";
    AvroSerializer serializer = new AvroSerializer();

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        Map auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        String userId = (String)auditInfo.get("user_id");
        Result resultUser = HybridQueryClient.getUserById((HttpServerExchange)exchange, (String)userId);
        String key = null;
        String country = null;
        String province = null;
        String city = null;
        if (resultUser.isSuccess()) {
            Map userMap = JsonMapper.string2Map((String)((String)resultUser.getResult()));
            country = (String)userMap.get("country");
            province = (String)userMap.get("province");
            city = (String)userMap.get("city");
            if (country == null || province == null || city == null) {
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, PROFILE_LOCATION_INCOMPLETE, new Object[0]));
            }
        } else {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultUser.getError()));
        }
        key = country + "|" + province + "|" + city;
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        String category = (String)map.get("category");
        String subcategory = (String)map.get("subcategory");
        double latitude = (Double)map.get("latitude");
        double longitude = (Double)map.get("longitude");
        String introduction = (String)map.get("introduction");
        Result resultCity = HybridQueryClient.getCity((HttpServerExchange)exchange, (String)country, (String)province, (String)city);
        if (resultCity.isFailure()) {
            if (resultCity.getError().getStatusCode() == 404) {
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, CITY_NOT_REGISTERED, new Object[]{key}));
            }
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultCity.getError()));
        }
        Result resultNonce = HybridQueryClient.getNonceByUserId((HttpServerExchange)exchange, (String)userId);
        if (resultNonce.isSuccess()) {
            EventId eventId = EventId.newBuilder().setId(userId).setNonce(Long.valueOf((String)resultNonce.getResult()).longValue()).setTimestamp(System.currentTimeMillis()).build();
            CovidEntityUpdatedEvent event = CovidEntityUpdatedEvent.newBuilder().setEventId(eventId).setHostId(hostId).setKey(key).setUserId(userId).setCategory(category).setSubcategory(subcategory).setLatitude(latitude).setLongitude(longitude).setIntroduction(introduction).build();
            byte[] bytes = this.serializer.serialize((Object)event);
            ProducerRecord record = new ProducerRecord(config.getTopic(), (Object)(config.isMultitenancy() ? hostId : userId).getBytes(StandardCharsets.UTF_8), (Object)bytes);
            CountDownLatch latch = new CountDownLatch(1);
            try {
                HybridCommandStartup.producer.send(record, (recordMetadata, e) -> {
                    if (Objects.nonNull(e)) {
                        logger.error("Exception occurred while pushing the event", (Throwable)e);
                    } else {
                        logger.info("Event record pushed successfully. Received Record Metadata is {}", (Object)recordMetadata);
                    }
                    latch.countDown();
                });
                latch.await();
            }
            catch (InterruptedException e2) {
                logger.error("Exception:", (Throwable)e2);
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, SEND_MESSAGE_EXCEPTION, new Object[]{e2.getMessage(), config.isMultitenancy() ? hostId : userId}));
            }
        } else {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultNonce.getError()));
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, "SUC10200", new Object[0]));
    }
}

