/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.auth.login.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.osiam.auth.login.internal.InternalAuthentication;
import org.osiam.resources.exception.ResourceNotFoundException;
import org.osiam.resources.provisioning.SCIMUserProvisioning;
import org.osiam.resources.scim.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.encoding.ShaPasswordEncoder;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class InternalAuthenticationProvider
implements AuthenticationProvider,
ApplicationListener<AbstractAuthenticationEvent> {
    private final Map<String, Integer> accessCounter = Collections.synchronizedMap(new HashMap());
    private final Map<String, Date> lastFailedLogin = Collections.synchronizedMap(new HashMap());
    private final SCIMUserProvisioning userProvisioning;
    private final ShaPasswordEncoder shaPasswordEncoder;
    private final BCryptPasswordEncoder bCryptPasswordEncoder;
    private final Integer maxLoginFailures;
    private final Integer lockTimeout;

    @Autowired
    public InternalAuthenticationProvider(SCIMUserProvisioning userProvisioning, ShaPasswordEncoder shaPasswordEncoder, BCryptPasswordEncoder bCryptPasswordEncoder, @Value(value="${osiam.tempLock.count:0}") Integer maxLoginFailures, @Value(value="${osiam.tempLock.timeout:0}") Integer lockTimeout) {
        this.userProvisioning = userProvisioning;
        this.shaPasswordEncoder = shaPasswordEncoder;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.maxLoginFailures = maxLoginFailures;
        this.lockTimeout = lockTimeout;
    }

    public Authentication authenticate(Authentication authentication) {
        User user;
        Preconditions.checkArgument((boolean)(authentication instanceof InternalAuthentication), (Object)"InternalAuthenticationProvider only supports InternalAuthentication.");
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        if (Strings.isNullOrEmpty((String)username)) {
            throw new BadCredentialsException("InternalAuthenticationProvider: Empty Username");
        }
        if (Strings.isNullOrEmpty((String)password)) {
            throw new BadCredentialsException("InternalAuthenticationProvider: Empty Password");
        }
        this.assertUserNotLocked(username);
        try {
            user = this.userProvisioning.getByUsernameWithPassword(username);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new BadCredentialsException("The user with the username '" + username + "' doesn't exist!", (Throwable)rnfe);
        }
        if (user.isActive() != Boolean.TRUE) {
            throw new DisabledException("The user with the username '" + username + "' is disabled!");
        }
        if (!this.bCryptPasswordEncoder.matches((CharSequence)password, user.getPassword())) {
            if (this.shaPasswordEncoder.isPasswordValid(user.getPassword(), password, (Object)user.getId())) {
                User replaceUser = new User.Builder(user).setPassword(password).build();
                this.userProvisioning.replace(user.getId(), replaceUser);
            } else {
                throw new BadCredentialsException("Bad credentials");
            }
        }
        User authUser = new User.Builder(username).setId(user.getId()).build();
        List grantedAuthorities = user.getRoles().stream().map(role -> new SimpleGrantedAuthority(role.getValue())).collect(Collectors.toList());
        return new InternalAuthentication((Object)authUser, (Object)password, grantedAuthorities);
    }

    public boolean supports(Class<?> authentication) {
        return InternalAuthentication.class.isAssignableFrom(authentication);
    }

    private void assertUserNotLocked(String username) {
        if (this.isLockMechanismDisabled()) {
            return;
        }
        Date logindate = (Date)this.lastFailedLogin.get(username);
        if (logindate != null && this.isWaitTimeOver(logindate)) {
            this.accessCounter.remove(username);
            this.lastFailedLogin.remove(username);
        }
        if (this.accessCounter.get(username) != null && (Integer)this.accessCounter.get(username) >= this.maxLoginFailures) {
            throw new LockedException("The user '" + username + "' is temporary locked.");
        }
    }

    private boolean isWaitTimeOver(Date startWaitingDate) {
        return System.currentTimeMillis() - startWaitingDate.getTime() >= TimeUnit.SECONDS.toMillis(this.lockTimeout.intValue());
    }

    private boolean isLockMechanismDisabled() {
        return this.maxLoginFailures <= 0;
    }

    public void onApplicationEvent(AbstractAuthenticationEvent appEvent) {
        String currentUserName = this.extractUserName(appEvent);
        if (currentUserName == null || this.isLockMechanismDisabled()) {
            return;
        }
        if (appEvent instanceof AuthenticationSuccessEvent && this.accessCounter.containsKey(currentUserName) && (Integer)this.accessCounter.get(currentUserName) < this.maxLoginFailures) {
            this.accessCounter.remove(currentUserName);
            this.lastFailedLogin.remove(currentUserName);
        }
        if (appEvent instanceof AuthenticationFailureBadCredentialsEvent) {
            if (this.accessCounter.containsKey(currentUserName)) {
                this.accessCounter.put(currentUserName, (Integer)this.accessCounter.get(currentUserName) + 1);
            } else {
                this.accessCounter.put(currentUserName, 1);
            }
            this.lastFailedLogin.put(currentUserName, new Date());
        }
    }

    private String extractUserName(AbstractAuthenticationEvent appEvent) {
        InternalAuthentication internalAuth;
        if (appEvent.getSource() != null && appEvent.getSource() instanceof InternalAuthentication && (internalAuth = (InternalAuthentication)appEvent.getSource()).getPrincipal() != null) {
            if (internalAuth.getPrincipal() instanceof User) {
                User user = (User)internalAuth.getPrincipal();
                return user.getUserName();
            }
            if (internalAuth.getPrincipal() instanceof String) {
                return (String)internalAuth.getPrincipal();
            }
        }
        return null;
    }
}

