/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.auth.login.ldap;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import org.osiam.auth.exception.LdapAuthenticationProcessException;
import org.osiam.auth.login.ldap.OsiamLdapAuthentication;
import org.osiam.auth.login.ldap.OsiamLdapUserContextMapper;
import org.osiam.resources.exception.ResourceNotFoundException;
import org.osiam.resources.provisioning.SCIMUserProvisioning;
import org.osiam.resources.scim.Extension;
import org.osiam.resources.scim.Role;
import org.osiam.resources.scim.User;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class OsiamLdapAuthenticationProvider
extends LdapAuthenticationProvider {
    private final SCIMUserProvisioning userProvisioning;
    private final boolean syncUserData;
    private final OsiamLdapUserContextMapper osiamLdapUserContextMapper;

    public OsiamLdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator, OsiamLdapUserContextMapper osiamLdapUserContextMapper, SCIMUserProvisioning userProvisioning, boolean syncUserData) {
        super(authenticator, authoritiesPopulator);
        this.osiamLdapUserContextMapper = osiamLdapUserContextMapper;
        this.userProvisioning = userProvisioning;
        this.syncUserData = syncUserData;
    }

    public boolean supports(Class<?> authentication) {
        return OsiamLdapAuthentication.class.isAssignableFrom(authentication);
    }

    public Authentication authenticate(Authentication authentication) {
        Preconditions.checkArgument((boolean)(authentication instanceof OsiamLdapAuthentication), (Object)"OsiamLdapAuthenticationProvider only supports OsiamLdapAuthentication.");
        OsiamLdapAuthentication userToken = (OsiamLdapAuthentication)authentication;
        String username = userToken.getName();
        String password = (String)authentication.getCredentials();
        if (Strings.isNullOrEmpty((String)username)) {
            throw new BadCredentialsException("OsiamLdapAuthenticationProvider: Empty Username");
        }
        if (Strings.isNullOrEmpty((String)password)) {
            throw new BadCredentialsException("OsiamLdapAuthenticationProvider: Empty Password");
        }
        User user = null;
        try {
            user = this.userProvisioning.getByUsername(username);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {}
        this.checkIfInternalUserExists(user);
        DirContextOperations userData = this.doAuthentication((UsernamePasswordAuthenticationToken)userToken);
        this.osiamLdapUserContextMapper.mapUserFromContext(userData, authentication.getName(), this.loadUserAuthorities(userData, authentication.getName(), (String)authentication.getCredentials()));
        user = this.synchronizeLdapData(userData, user);
        if (!user.isActive().booleanValue()) {
            throw new DisabledException("The user with the username '" + username + "' is disabled!");
        }
        User authUser = new User.Builder(username).setId(user.getId()).build();
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        for (Role role : user.getRoles()) {
            grantedAuthorities.add(new SimpleGrantedAuthority(role.getValue()));
        }
        UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)authUser, null, grantedAuthorities);
        result.setDetails(authentication.getDetails());
        return result;
    }

    private void checkIfInternalUserExists(User user) {
        if (user != null && !this.hasAuthServerExtension(user)) {
            throw new LdapAuthenticationProcessException("Can't create the ldap user with the username '" + user.getUserName() + "'. An internal user with the same username already exists.");
        }
    }

    private boolean hasAuthServerExtension(User user) {
        if (!user.isExtensionPresent("urn:org.osiam:scim:extensions:auth-server")) {
            return false;
        }
        Extension authExtension = user.getExtension("urn:org.osiam:scim:extensions:auth-server");
        return authExtension.isFieldPresent("origin") && authExtension.getFieldAsString("origin").equals("ldap");
    }

    private User synchronizeLdapData(DirContextOperations ldapUserData, User user) {
        if (user == null) {
            return this.userProvisioning.create(this.osiamLdapUserContextMapper.mapUser(ldapUserData));
        }
        if (this.syncUserData) {
            return this.userProvisioning.update(user.getId(), this.osiamLdapUserContextMapper.mapUpdateUser(user, ldapUserData).getScimConformUpdateUser());
        }
        return user;
    }
}

