/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.oauth;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.osiam.client.helper.ScopeDeserializer;
import org.osiam.client.helper.ScopeSerializer;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.oauth.Scope;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class AccessToken {
    @JsonProperty(value="access_token")
    private String token;
    @JsonProperty(value="expires_at")
    private Date expiresAt;
    @JsonSerialize(using=ScopeSerializer.class)
    @JsonDeserialize(using=ScopeDeserializer.class)
    @JsonProperty(value="scope")
    private Set<Scope> scopes = new HashSet();
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    @JsonProperty(value="refresh_token_expires_at")
    private Date refreshTokenExpiresAt;
    @JsonProperty(value="token_type")
    private String type;
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="user_name")
    private String userName;

    private AccessToken() {
    }

    private AccessToken(Builder builder) {
        this.token = Builder.access$0((Builder)builder);
        this.expiresAt = Builder.access$1((Builder)builder);
        this.scopes = Builder.access$2((Builder)builder);
        this.refreshToken = Builder.access$3((Builder)builder);
        this.refreshTokenExpiresAt = Builder.access$4((Builder)builder);
        this.type = Builder.access$5((Builder)builder);
        this.clientId = Builder.access$6((Builder)builder);
        this.userId = Builder.access$7((Builder)builder);
        this.userName = Builder.access$8((Builder)builder);
    }

    public String getToken() {
        return this.token;
    }

    public Date getExpiresAt() {
        if (this.expiresAt != null) {
            return new Date(this.expiresAt.getTime());
        }
        return null;
    }

    public boolean isExpired() {
        return this.expiresAt.before(new Date());
    }

    public Set<Scope> getScopes() {
        return this.scopes;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Date getRefreshTokenExpiresAt() {
        if (this.refreshTokenExpiresAt != null) {
            return new Date(this.refreshTokenExpiresAt.getTime());
        }
        return null;
    }

    public boolean isRefreshTokenExpired() {
        return this.refreshTokenExpiresAt.before(new Date());
    }

    public String getType() {
        return this.type;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isClientOnly() {
        return Strings.isNullOrEmpty((String)this.userName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessToken other = (AccessToken)obj;
        return !(this.token == null ? other.token != null : !this.token.equals(other.token));
    }

    public String toString() {
        return "AccessToken [token=" + this.token + ", expiresAt=" + this.expiresAt + ", scopes=" + this.scopes + ", refreshTokenId=" + this.refreshToken + ", refreshTokenExpiresAt=" + this.refreshTokenExpiresAt + ", clientId=" + this.clientId + ", userId=" + this.userId + ", userName=" + this.userName + "]";
    }

    /* synthetic */ AccessToken(Builder builder, AccessToken accessToken) {
        this(builder);
    }
}

