/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.configuration;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.osiam.auth.login.ldap.OsiamLdapAuthenticationProvider;
import org.osiam.auth.login.ldap.OsiamLdapUserContextMapper;
import org.osiam.auth.login.ldap.ScimToLdapAttributeMapping;
import org.osiam.resources.provisioning.SCIMUserProvisioning;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

@Configuration
@ConditionalOnProperty(value={"osiam.ldap.enabled"})
@ConfigurationProperties(value="osiam.ldap")
public class LdapAuthentication {
    public static final String LDAP_PROVIDER = "ldap";
    private String serverUrl = "";
    private String[] dnPatterns = new String[0];
    private Map<String, String> userMapping = new HashMap();

    @Bean
    public ScimToLdapAttributeMapping ldapToScimAttributeMapping() {
        return new ScimToLdapAttributeMapping(this.userMapping);
    }

    @Bean
    @Autowired
    public OsiamLdapAuthenticationProvider osiamLdapAuthenticationProvider(SCIMUserProvisioning userProvisioning, @Value(value="${osiam.ldap.sync-user-data:true}") boolean syncUserData) {
        return new OsiamLdapAuthenticationProvider(this.bindAuthenticator(), (LdapAuthoritiesPopulator)new DefaultLdapAuthoritiesPopulator((ContextSource)this.contextSource(), ""), new OsiamLdapUserContextMapper(this.ldapToScimAttributeMapping()), userProvisioning, syncUserData);
    }

    @Bean
    public BaseLdapPathContextSource contextSource() {
        return new DefaultSpringSecurityContextSource(this.serverUrl);
    }

    @Bean
    public LdapAuthenticator bindAuthenticator() {
        BindAuthenticator bindAuthenticator = new BindAuthenticator(this.contextSource());
        bindAuthenticator.setUserDnPatterns(this.dnPatterns);
        bindAuthenticator.setUserAttributes((String[])Iterables.toArray((Iterable)this.ldapToScimAttributeMapping().ldapAttributes(), String.class));
        return bindAuthenticator;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String[] getDnPatterns() {
        return this.dnPatterns;
    }

    public Map<String, String> getUserMapping() {
        return this.userMapping;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setDnPatterns(String[] dnPatterns) {
        this.dnPatterns = dnPatterns;
    }
}

