/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.exception;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import org.osiam.auth.exception.ClientAlreadyExistsException;
import org.osiam.auth.exception.ClientNotFoundException;
import org.osiam.auth.exception.JsonErrorResult;
import org.osiam.resources.exception.ErrorMessageTransformer;
import org.osiam.resources.exception.InvalidConstraintException;
import org.osiam.resources.exception.InvalidFilterException;
import org.osiam.resources.exception.InvalidTokenException;
import org.osiam.resources.exception.JsonMappingMessageTransformer;
import org.osiam.resources.exception.JsonPropertyMessageTransformer;
import org.osiam.resources.exception.NoSuchElementException;
import org.osiam.resources.exception.OsiamBackendFailureException;
import org.osiam.resources.exception.OsiamException;
import org.osiam.resources.exception.ResourceExistsException;
import org.osiam.resources.exception.ResourceNotFoundException;
import org.osiam.resources.exception.SchemaUnknownException;
import org.osiam.resources.scim.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice(value={"org.osiam.auth.oauth_client", "org.osiam.metrics.controller", "org.osiam.resources.controller"})
public class RestExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(RestExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorResponse defaultExceptionHandler(Exception ex) {
        logger.warn("An unexpected exception occurred", (Throwable)ex);
        return this.produceErrorResponse("An unexpected error occurred", HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={OsiamException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public ErrorResponse handleOsiamException(OsiamException e) {
        return this.produceErrorResponse(e.getMessage(), HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={IllegalArgumentException.class, InvalidFilterException.class, InvalidConstraintException.class, InvalidTokenException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorResponse handleInvalidRequests(Exception e) {
        return this.produceErrorResponse(e.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorResponse handleValidationException(MethodArgumentNotValidException ex) {
        BindingResult bindingResult = ex.getBindingResult();
        String message = bindingResult.getFieldError().getDefaultMessage();
        return this.produceErrorResponse(message, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ResourceExistsException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public ErrorResponse handleResourceExists(ResourceExistsException e) {
        return this.produceErrorResponse(e.getMessage(), HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={OsiamBackendFailureException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorResponse handleBackendFailure() {
        return this.produceErrorResponse("An internal error occurred", HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={ResourceNotFoundException.class, NoSuchElementException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public ErrorResponse handleResourceNotFoundException(Exception e) {
        return this.produceErrorResponse(e.getMessage(), HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ClientNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    protected JsonErrorResult handleClientNotFound(ClientNotFoundException e) {
        logger.warn(e.getMessage());
        return new JsonErrorResult(HttpStatus.NOT_FOUND.name(), e.getMessage());
    }

    @ExceptionHandler(value={ClientAlreadyExistsException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    protected JsonErrorResult handleClientAlreadyExists(ClientAlreadyExistsException e) {
        logger.warn(e.getMessage());
        return new JsonErrorResult(HttpStatus.CONFLICT.name(), e.getMessage());
    }

    @ExceptionHandler(value={SchemaUnknownException.class})
    @ResponseStatus(value=HttpStatus.I_AM_A_TEAPOT)
    @ResponseBody
    public ErrorResponse handleSchemaUnknown(SchemaUnknownException e) {
        return this.produceErrorResponse(e.getMessage(), HttpStatus.I_AM_A_TEAPOT);
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    @ResponseStatus(value=HttpStatus.NOT_IMPLEMENTED)
    @ResponseBody
    public ErrorResponse handleUnsupportedOperation(UnsupportedOperationException e) {
        return this.produceErrorResponse(e.getMessage(), HttpStatus.NOT_IMPLEMENTED);
    }

    @ExceptionHandler(value={UnrecognizedPropertyException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public ErrorResponse handleUnrecognizedProperty(UnrecognizedPropertyException e) {
        logger.error("Unknown property", (Throwable)e);
        return this.produceErrorResponse(e.getMessage(), HttpStatus.CONFLICT, (ErrorMessageTransformer)new JsonPropertyMessageTransformer());
    }

    @ExceptionHandler(value={JsonMappingException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public ErrorResponse handleJsonMapping(JsonMappingException e) {
        logger.error("Unable to deserialize", (Throwable)e);
        return this.produceErrorResponse(e.getMessage(), HttpStatus.CONFLICT, (ErrorMessageTransformer)new JsonMappingMessageTransformer());
    }

    private ErrorResponse produceErrorResponse(String message, HttpStatus status) {
        return this.produceErrorResponse(message, status, null);
    }

    private ErrorResponse produceErrorResponse(String message, HttpStatus status, ErrorMessageTransformer transformer) {
        if (transformer != null) {
            message = transformer.transform(message);
        }
        return new ErrorResponse(status.value(), message);
    }
}

