/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.helper;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.osiam.resources.scim.Extension;
import org.osiam.resources.scim.ExtensionFieldType;

public class ExtensionSerializer
extends JsonSerializer<Extension> {
    public void serialize(Extension value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        Map fields = value.getFields();
        for (Map.Entry entry : fields.entrySet()) {
            String fieldName = (String)entry.getKey();
            ExtensionFieldType fieldType = ((Extension.Field)entry.getValue()).getType();
            String rawFieldValue = ((Extension.Field)entry.getValue()).getValue();
            jgen.writeFieldName(fieldName);
            if (fieldType == ExtensionFieldType.INTEGER) {
                BigInteger valueAsBigInteger = (BigInteger)ExtensionFieldType.INTEGER.fromString(rawFieldValue);
                jgen.writeNumber(valueAsBigInteger);
                continue;
            }
            if (fieldType == ExtensionFieldType.DECIMAL) {
                BigDecimal valueAsBigDecimal = (BigDecimal)ExtensionFieldType.DECIMAL.fromString(rawFieldValue);
                jgen.writeNumber(valueAsBigDecimal);
                continue;
            }
            if (fieldType == ExtensionFieldType.BOOLEAN) {
                Boolean valueAsBoolean = (Boolean)ExtensionFieldType.BOOLEAN.fromString(rawFieldValue);
                jgen.writeBoolean(valueAsBoolean.booleanValue());
                continue;
            }
            jgen.writeString(rawFieldValue);
        }
        jgen.writeEndObject();
    }
}

