/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import org.osiam.resources.converter.RoleConverter;
import org.osiam.resources.scim.Role;
import org.osiam.storage.entities.RoleEntity;
import org.osiam.storage.entities.UserEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class RoleUpdater {
    private final RoleConverter roleConverter;

    @Autowired
    public RoleUpdater(RoleConverter roleConverter) {
        this.roleConverter = roleConverter;
    }

    void update(List<Role> roles, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("roles")) {
            userEntity.removeAllRoles();
        }
        if (roles != null) {
            for (Role scimRole : roles) {
                RoleEntity roleEntity = this.roleConverter.fromScim(scimRole);
                userEntity.removeRole(roleEntity);
                if (!Strings.isNullOrEmpty((String)scimRole.getOperation()) && scimRole.getOperation().equalsIgnoreCase("delete")) continue;
                this.ensureOnlyOnePrimaryRoleExists(roleEntity, userEntity.getRoles());
                userEntity.addRole(roleEntity);
            }
        }
    }

    private void ensureOnlyOnePrimaryRoleExists(RoleEntity newRole, Set<RoleEntity> roles) {
        if (newRole.isPrimary()) {
            for (RoleEntity existingRoleEntity : roles) {
                if (!existingRoleEntity.isPrimary()) continue;
                existingRoleEntity.setPrimary(false);
            }
        }
    }
}

