/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.osiam.resources.data.ImageDataURI;
import org.osiam.resources.data.PhotoValueType;
import org.osiam.resources.exception.SCIMDataValidationException;
import org.osiam.resources.scim.MultiValuedAttribute;
import org.osiam.resources.scim.Photo;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public final class Photo
extends MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = -3801047382575408796L;
    private Type type;

    @JsonCreator
    public Photo(@JsonProperty(value="operation") String operation, @JsonProperty(value="value") String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="$ref") String reference, @JsonProperty(value="type") Type type) {
        super(operation, value, display, primary, reference);
        this.type = type;
    }

    private Photo(Builder builder) {
        super((MultiValuedAttribute.Builder)builder);
        this.type = Builder.access$4((Builder)builder);
    }

    public String getOperation() {
        return super.getOperation();
    }

    public URI getValueAsURI() {
        URI uri;
        try {
            uri = new URI(super.getValue());
        }
        catch (URISyntaxException e) {
            throw new SCIMDataValidationException(e.getMessage(), (Throwable)e);
        }
        return uri;
    }

    @JsonIgnore
    public ImageDataURI getValueAsImageDataURI() {
        return new ImageDataURI(super.getValue());
    }

    @JsonIgnore
    public PhotoValueType getValueType() {
        if (super.getValue().startsWith("data:image/") && super.getValue().contains(";base64,")) {
            try {
                this.getValueAsImageDataURI();
                return PhotoValueType.IMAGE_DATA_URI;
            }
            catch (Exception exception) {}
        }
        try {
            this.getValueAsURI();
            return PhotoValueType.URI;
        }
        catch (Exception exception) {
            return PhotoValueType.UNKNOWN;
        }
    }

    public String getDisplay() {
        return super.getDisplay();
    }

    public boolean isPrimary() {
        return super.isPrimary();
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Photo other = (Photo)obj;
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public String toString() {
        return "Photo [value=" + this.getValue() + ", type=" + this.type + ", primary=" + this.isPrimary() + ", operation=" + this.getOperation() + "]";
    }

    static /* synthetic */ Type access$0(Photo photo) {
        return photo.type;
    }

    /* synthetic */ Photo(Builder builder, Photo photo) {
        this(builder);
    }
}

