/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.security.authorization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.osiam.security.authentication.OsiamClientDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.approval.DefaultUserApprovalHandler;
import org.springframework.stereotype.Component;

@Component
public class OsiamUserApprovalHandler
extends DefaultUserApprovalHandler {
    private static final String APPROVALS_SESSION_KEY = "osiam_oauth_approvals";
    private static final String IS_PRE_APPROVED_PARAMETER = "osiam_is_pre_approved";
    private final HttpSession httpSession;
    private final OsiamClientDetailsService osiamClientDetailsService;

    @Autowired
    public OsiamUserApprovalHandler(HttpSession httpSession, OsiamClientDetailsService osiamClientDetailsService) {
        this.httpSession = httpSession;
        this.osiamClientDetailsService = osiamClientDetailsService;
    }

    public AuthorizationRequest checkForPreApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        ClientDetails client = this.osiamClientDetailsService.loadClientByClientId(authorizationRequest.getClientId());
        if (client.isAutoApprove("") || this.hasRememberedApprovalForClient(authorizationRequest, client)) {
            authorizationRequest.setApproved(true);
            HashMap<String, String> newApprovalParameters = new HashMap<String, String>(authorizationRequest.getApprovalParameters());
            newApprovalParameters.put(IS_PRE_APPROVED_PARAMETER, "true");
            authorizationRequest.setApprovalParameters(Collections.unmodifiableMap(newApprovalParameters));
        }
        return authorizationRequest;
    }

    public boolean isApproved(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        boolean approved = super.isApproved(authorizationRequest, userAuthentication);
        if (!approved) {
            return false;
        }
        if ("true".equals(authorizationRequest.getApprovalParameters().get(IS_PRE_APPROVED_PARAMETER))) {
            return true;
        }
        ConcurrentHashMap<String, Long> approvals = (ConcurrentHashMap<String, Long>)this.httpSession.getAttribute(APPROVALS_SESSION_KEY);
        if (approvals == null) {
            approvals = new ConcurrentHashMap<String, Long>();
            this.httpSession.setAttribute(APPROVALS_SESSION_KEY, approvals);
        }
        if (!approvals.containsKey(authorizationRequest.getClientId())) {
            approvals.put(authorizationRequest.getClientId(), System.currentTimeMillis());
        }
        return true;
    }

    private boolean hasRememberedApprovalForClient(AuthorizationRequest authorizationRequest, ClientDetails client) {
        Map approvals = (Map)this.httpSession.getAttribute(APPROVALS_SESSION_KEY);
        if (approvals == null) {
            return false;
        }
        Long approvalTime = (Long)approvals.get(authorizationRequest.getClientId());
        if (approvalTime == null) {
            return false;
        }
        long validityInSeconds = (Long)client.getAdditionalInformation().get("validityInSeconds");
        if (System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(validityInSeconds) > approvalTime) {
            approvals.remove(authorizationRequest.getClientId());
            return false;
        }
        return true;
    }
}

