/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.security.controller;

import com.google.common.base.Strings;
import java.util.Optional;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/login"})
public class LoginController {
    private static final String SESSION_ERROR_KEY = "ERROR_KEY";
    private static final String MODEL_ERROR_KEY = "errorKey";
    private final HttpSession session;
    private final boolean isLdapConfigured;
    private final int templockTimeout;

    @Autowired
    public LoginController(HttpSession session, @Value(value="${osiam.ldap.enabled:false}") boolean isLdapConfigured, @Value(value="${osiam.tempLock.timeout:0}") int templockTimeout) {
        this.session = session;
        this.isLdapConfigured = isLdapConfigured;
        this.templockTimeout = templockTimeout;
    }

    @RequestMapping
    public String login() {
        return "login";
    }

    @RequestMapping(value={"/error"})
    public ModelAndView loginError() {
        ModelAndView modelAndView = new ModelAndView("login");
        modelAndView.addObject("loginError", (Object)true);
        if (this.userIsLocked()) {
            modelAndView.addObject(MODEL_ERROR_KEY, (Object)"login.lock");
            modelAndView.addObject("templockTimeout", (Object)this.templockTimeout);
            return modelAndView;
        }
        Optional errorMessageFromSession = this.getErrorMessageFromSession();
        if (errorMessageFromSession.isPresent()) {
            modelAndView.addObject(MODEL_ERROR_KEY, errorMessageFromSession.get());
            return modelAndView;
        }
        modelAndView.addObject(MODEL_ERROR_KEY, (Object)"login.error");
        return modelAndView;
    }

    @ModelAttribute(value="isLdapConfigured")
    public boolean isLdapConfigured() {
        return this.isLdapConfigured;
    }

    private Optional<String> getErrorMessageFromSession() {
        Object attribute = this.session.getAttribute(SESSION_ERROR_KEY);
        if (attribute == null || !(attribute instanceof String)) {
            return Optional.empty();
        }
        String errorMessage = (String)attribute;
        this.session.removeAttribute(SESSION_ERROR_KEY);
        return Optional.ofNullable(Strings.emptyToNull((String)errorMessage));
    }

    private boolean userIsLocked() {
        return this.session.getAttribute("IS_LOCKED") != null && this.session.getAttribute("IS_LOCKED") instanceof Boolean && (Boolean)this.session.getAttribute("IS_LOCKED") != false;
    }
}

