/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.security.helper;

import com.google.common.base.Strings;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osiam.auth.login.internal.InternalAuthentication;
import org.osiam.auth.login.ldap.OsiamLdapAuthentication;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class LoginDecisionFilter
extends AbstractAuthenticationProcessingFilter {
    public static final String USERNAME_PARAMETER = "username";
    private static final String PASSWORD_PARAMETER = "password";
    private boolean postOnly = true;

    public LoginDecisionFilter() {
        super("/login/check");
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        if (this.postOnly && !request.getMethod().equals("POST")) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        String username = request.getParameter(this.getUsernameParameter());
        String password = request.getParameter(this.getPasswordParameter());
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        username = username.trim();
        String provider = request.getParameter("provider");
        Object authRequest = !Strings.isNullOrEmpty((String)provider) && provider.equals("ldap") ? new OsiamLdapAuthentication((Object)username, (Object)password) : new InternalAuthentication((Object)username, (Object)password);
        this.setDetails(request, (UsernamePasswordAuthenticationToken)authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    public void setPostOnly(boolean postOnly) {
        this.postOnly = postOnly;
    }

    public final String getUsernameParameter() {
        return USERNAME_PARAMETER;
    }

    public final String getPasswordParameter() {
        return PASSWORD_PARAMETER;
    }
}

