/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.entities;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.hibernate.annotations.BatchSize;
import org.osiam.resources.scim.MemberRef;
import org.osiam.storage.entities.ResourceEntity;

@Entity
@Table(name="scim_group")
public class GroupEntity
extends ResourceEntity {
    private static final int BATCH_SIZE = 100;
    @ManyToMany
    @BatchSize(size=100)
    private Set<ResourceEntity> members = new HashSet();
    @Column(unique=true, nullable=false)
    private String displayName;

    public GroupEntity() {
        this.getMeta().setResourceType("Group");
    }

    public Set<ResourceEntity> getMembers() {
        return ImmutableSet.copyOf((Collection)this.members);
    }

    public void addMember(ResourceEntity member) {
        if (this.members.contains(member)) {
            return;
        }
        this.members.add(member);
        member.addToGroup(this);
    }

    public void removeMember(ResourceEntity member) {
        if (!this.members.contains(member)) {
            return;
        }
        this.members.remove(member);
        member.removeFromGroup(this);
    }

    public void removeAllMembers() {
        ImmutableSet membersToRemove = ImmutableSet.copyOf((Collection)this.members);
        for (ResourceEntity member : membersToRemove) {
            this.removeMember(member);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String toString() {
        return "GroupEntity [displayName=" + this.displayName + ", getId()=" + this.getId() + "]";
    }

    public MemberRef.Type getType() {
        return MemberRef.Type.GROUP;
    }
}

