/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.query;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.osiam.storage.entities.ResourceEntity;
import org.osiam.storage.parser.LogicalOperatorRulesBaseVisitor;
import org.osiam.storage.parser.LogicalOperatorRulesParser;
import org.osiam.storage.query.FilterChain;
import org.osiam.storage.query.FilterConstraint;
import org.osiam.storage.query.FilterExpression;
import org.osiam.storage.query.FilterParser;

public class EvalVisitor<T extends ResourceEntity>
extends LogicalOperatorRulesBaseVisitor<Predicate> {
    private final FilterParser<T> filterParser;
    private final Root<T> root;

    public EvalVisitor(FilterParser<T> filterParser, Root<T> root) {
        this.filterParser = filterParser;
        this.root = root;
    }

    public Predicate visitAndExp(@NotNull LogicalOperatorRulesParser.AndExpContext ctx) {
        Predicate left = (Predicate)this.visit((ParseTree)ctx.expression(0));
        Predicate right = (Predicate)this.visit((ParseTree)ctx.expression(1));
        return this.filterParser.entityManager.getCriteriaBuilder().and((Expression)left, (Expression)right);
    }

    public Predicate visitBraceExp(@NotNull LogicalOperatorRulesParser.BraceExpContext ctx) {
        return (Predicate)this.visit((ParseTree)ctx.expression());
    }

    public Predicate visitSimpleExp(@NotNull LogicalOperatorRulesParser.SimpleExpContext ctx) {
        FilterExpression filterExpression = this.getFilterExpressionFromContext(ctx);
        FilterChain filterChain = this.filterParser.createFilterChain(filterExpression);
        return filterChain.createPredicateAndJoin(this.root);
    }

    private FilterExpression<T> getFilterExpressionFromContext(LogicalOperatorRulesParser.SimpleExpContext ctx) {
        String fieldName = ctx.FIELD().getText();
        String value = ctx.VALUE().getText();
        value = value.substring(1, value.length() - 1);
        value = value.replace("\\\"", "\"");
        FilterConstraint operator = FilterConstraint.fromString((String)ctx.OPERATOR().getText());
        return this.filterParser.createFilterExpression(fieldName, operator, value);
    }

    public Predicate visitSimplePresentExp(@NotNull LogicalOperatorRulesParser.SimplePresentExpContext ctx) {
        String fieldName = ctx.FIELD().getText();
        FilterConstraint operator = FilterConstraint.fromString((String)ctx.PRESENT().getText());
        FilterExpression filterExpression = this.filterParser.createFilterExpression(fieldName, operator, null);
        FilterChain filterChain = this.filterParser.createFilterChain(filterExpression);
        return filterChain.createPredicateAndJoin(this.root);
    }

    public Predicate visitNotExp(@NotNull LogicalOperatorRulesParser.NotExpContext ctx) {
        Predicate term = (Predicate)this.visit((ParseTree)ctx.expression());
        return this.filterParser.entityManager.getCriteriaBuilder().not((Expression)term);
    }

    public Predicate visitOrExp(@NotNull LogicalOperatorRulesParser.OrExpContext ctx) {
        Predicate left = (Predicate)this.visit((ParseTree)ctx.expression(0));
        Predicate right = (Predicate)this.visit((ParseTree)ctx.expression(1));
        return this.filterParser.entityManager.getCriteriaBuilder().or((Expression)left, (Expression)right);
    }
}

