/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.directive;

import com.graphql_java_generator.client.directive.Directive;
import com.graphql_java_generator.client.directive.DirectiveRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.stereotype.Component;

@Component
public class DirectiveRegistryImpl
implements DirectiveRegistry {
    private static Map<String, DirectiveRegistry> directiveRegistries = new HashMap<String, DirectiveRegistry>();
    private static Map<String, Directive> directiveTypes = new HashMap<String, Directive>();

    public static void registerDirectiveRegistry(String schema, Consumer<DirectiveRegistry> directiveRegistryInitializer) {
        if (!directiveRegistries.containsKey(schema)) {
            DirectiveRegistryImpl directiveRegistry = new DirectiveRegistryImpl();
            directiveRegistryInitializer.accept(directiveRegistry);
            directiveRegistries.put(schema, directiveRegistry);
        }
    }

    public static Directive getDirective(String schema, String directiveName) {
        return directiveRegistries.get(schema).getDirective(directiveName);
    }

    @Override
    public void registerDirective(Directive type) {
        directiveTypes.put(type.getName(), type);
    }

    @Override
    public Directive getDirective(String name) {
        return directiveTypes.get(name);
    }
}

