/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.annotation.RequestType;
import com.graphql_java_generator.client.GraphQLJsonMapper;
import com.graphql_java_generator.client.GraphQLRequestObject;
import com.graphql_java_generator.client.RegistriesInitializer;
import com.graphql_java_generator.client.SpringContextBean;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.client.SubscriptionClient;
import com.graphql_java_generator.client.SubscriptionClientReactiveImpl;
import com.graphql_java_generator.client.request.Fragment;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.client.request.QueryField;
import com.graphql_java_generator.client.request.QueryTokenizer;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestExecutionUncheckedException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import com.graphql_java_generator.util.GraphqlUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.graphql.client.ClientGraphQlResponse;
import org.springframework.graphql.client.GraphQlClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import tools.jackson.core.JacksonException;

public abstract class AbstractGraphQLRequest {
    static Logger logger = LoggerFactory.getLogger(AbstractGraphQLRequest.class);
    final GraphQlClient graphQlClient;
    final RegistriesInitializer registriesInitializer;
    QueryField query = null;
    QueryField mutation = null;
    QueryField subscription = null;
    Map<Class<?>, Map<String, Field>> aliasFields = new HashMap();
    List<Fragment> fragments = new ArrayList<Fragment>();
    final String graphQLRequest;
    RequestType requestType;
    final String requestName;

    public AbstractGraphQLRequest(GraphQlClient graphQlClient, RegistriesInitializer registriesInitializer, String graphQLRequest, RequestType requestType, String fieldName, InputParameter ... inputParams) throws GraphQLRequestPreparationException {
        QueryField field;
        if (registriesInitializer == null) {
            throw new NullPointerException("The registriesInitializer parameter may bot be null");
        }
        this.registriesInitializer = registriesInitializer;
        if (requestType == null) {
            throw new NullPointerException("requestType is mandatory, but a null value has been provided");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is mandatory, but a null value has been provided");
        }
        this.graphQlClient = graphQlClient == null ? SpringContextBean.getGraphQlClient(registriesInitializer.getSchema(), requestType) : graphQlClient;
        this.requestType = requestType;
        this.requestName = null;
        this.graphQLRequest = graphQLRequest;
        switch (requestType) {
            case query: {
                this.query = this.getQueryContext();
                field = new QueryField(this.query.clazz, fieldName);
                this.query.fields.add(field);
                break;
            }
            case mutation: {
                this.mutation = this.getMutationContext();
                field = new QueryField(this.mutation.clazz, fieldName);
                this.mutation.fields.add(field);
                break;
            }
            case subscription: {
                this.subscription = this.getSubscriptionContext();
                field = new QueryField(this.subscription.clazz, fieldName);
                this.subscription.fields.add(field);
                break;
            }
            default: {
                throw new GraphQLRequestPreparationException("Non managed request type '" + requestType + " while reading the GraphQL request: " + graphQLRequest);
            }
        }
        field.inputParameters = Arrays.asList(inputParams);
        QueryTokenizer qt = new QueryTokenizer(this.graphQLRequest);
        if (qt.hasMoreTokens()) {
            String token = qt.nextToken();
            if (!"{".equals(token)) {
                throw new GraphQLRequestPreparationException("The Partial GraphQL Request should start by a '{', but it doesn't: " + graphQLRequest);
            }
            field.readTokenizerForResponseDefinition(qt, this.aliasFields, registriesInitializer.getSchema());
        }
        this.finishRequestPreparation();
    }

    public AbstractGraphQLRequest(GraphQlClient graphQlClient, RegistriesInitializer registriesInitializer, String graphQLRequest) throws GraphQLRequestPreparationException {
        if (registriesInitializer == null) {
            throw new NullPointerException("The registriesInitializer parameter may bot be null");
        }
        this.registriesInitializer = registriesInitializer;
        String localQueryName = null;
        this.graphQLRequest = graphQLRequest;
        this.requestType = RequestType.query;
        boolean requestTypeHasBeenRead = false;
        ArrayList<InputParameter> inputParameters = new ArrayList<InputParameter>();
        QueryTokenizer qt = new QueryTokenizer(this.graphQLRequest);
        block21: while (qt.hasMoreTokens()) {
            String token;
            switch (token = qt.nextToken()) {
                case "fragment": {
                    this.fragments.add(new Fragment(qt, this.aliasFields, registriesInitializer.getPackageName(), false, null, registriesInitializer.getSchema()));
                    continue block21;
                }
                case "query": 
                case "mutation": 
                case "subscription": {
                    this.requestType = RequestType.valueOf((String)token);
                    requestTypeHasBeenRead = true;
                    continue block21;
                }
                case "(": {
                    try {
                        this.readRequestParameters(qt, inputParameters, registriesInitializer.getSchema());
                        continue block21;
                    }
                    catch (Exception e) {
                        throw new GraphQLRequestPreparationException(e.getMessage() + " (while reading the request parameters)", e);
                    }
                }
                case "{": {
                    switch (this.requestType) {
                        case query: {
                            this.query = this.getQueryContext();
                            this.query.inputParameters = inputParameters;
                            this.query.readTokenizerForResponseDefinition(qt, this.aliasFields, registriesInitializer.getSchema());
                            continue block21;
                        }
                        case mutation: {
                            this.mutation = this.getMutationContext();
                            this.mutation.inputParameters = inputParameters;
                            this.mutation.readTokenizerForResponseDefinition(qt, this.aliasFields, registriesInitializer.getSchema());
                            continue block21;
                        }
                        case subscription: {
                            this.subscription = this.getSubscriptionContext();
                            this.subscription.inputParameters = inputParameters;
                            this.subscription.readTokenizerForResponseDefinition(qt, this.aliasFields, registriesInitializer.getSchema());
                            continue block21;
                        }
                    }
                    throw new GraphQLRequestPreparationException("Non managed request type '" + this.requestType + " while reading the GraphQL request: " + graphQLRequest);
                }
            }
            if (requestTypeHasBeenRead) {
                localQueryName = token;
                continue;
            }
            this.requestType = RequestType.query;
            requestTypeHasBeenRead = true;
            localQueryName = token;
        }
        if (this.query == null && this.mutation == null && this.subscription == null) {
            throw new GraphQLRequestPreparationException("No response definition found");
        }
        this.graphQlClient = graphQlClient == null ? SpringContextBean.getGraphQlClient(registriesInitializer.getSchema(), this.requestType) : graphQlClient;
        this.requestName = localQueryName;
        this.finishRequestPreparation();
    }

    private void readRequestParameters(QueryTokenizer qt, List<InputParameter> inputParameters, String schema) throws GraphQLRequestPreparationException {
        block30: {
            Step step = Step.NAME;
            String parameterName = null;
            block17: while (true) {
                String token;
                if ((token = qt.nextToken()).equals(")")) {
                    if (step.equals((Object)Step.TYPE)) {
                        throw new GraphQLRequestPreparationException("Found a ')', while expecting a value for the '" + parameterName + "' query parameter");
                    }
                    break block30;
                }
                if (token.equals(",")) {
                    if (!step.equals((Object)Step.NAME)) {
                        throw new GraphQLRequestPreparationException("unexpected ','");
                    }
                    token = qt.nextToken();
                } else if (token.equals(":")) {
                    if (!step.equals((Object)Step.TYPE)) {
                        throw new GraphQLRequestPreparationException("unexpected ':'");
                    }
                    token = qt.nextToken();
                }
                switch (step) {
                    case NAME: {
                        if (!token.startsWith("$")) {
                            throw new GraphQLRequestPreparationException("The GraphQL variable names should start by a '$', but this one doesn't: '" + token + "'");
                        }
                        parameterName = token.substring(1);
                        step = Step.TYPE;
                        continue block17;
                    }
                    case TYPE: {
                        int currentDepth = 0;
                        String parameterTypeName = null;
                        boolean mandatory = false;
                        int listDepth = 0;
                        boolean itemMandatory = false;
                        while (true) {
                            switch (token) {
                                case "[": {
                                    ++listDepth;
                                    ++currentDepth;
                                    break;
                                }
                                case "]": {
                                    --currentDepth;
                                    break;
                                }
                                case "!": {
                                    itemMandatory = true;
                                    break;
                                }
                                case ",": 
                                case ")": {
                                    throw new GraphQLRequestPreparationException("Syntax error in the query, while reading the type of the '" + parameterName + "' parameter of the request");
                                }
                                default: {
                                    parameterTypeName = token;
                                }
                            }
                            if (currentDepth == 0) break;
                            token = qt.nextToken();
                        }
                        if (qt.checkNextToken("!")) {
                            mandatory = true;
                            token = qt.nextToken();
                        } else {
                            mandatory = false;
                        }
                        Object defaultValue = null;
                        if (qt.checkNextToken("=")) {
                            qt.nextToken();
                            qt.nextToken();
                            defaultValue = InputParameter.readTokenizerForInputParameterValue(qt, schema, parameterName, parameterTypeName);
                        }
                        inputParameters.add(InputParameter.newGraphQLVariableParameter(schema, parameterName, defaultValue, parameterTypeName, mandatory, listDepth, itemMandatory));
                        step = Step.NAME;
                        continue block17;
                    }
                }
                break;
            }
            throw new RuntimeException("Non managed step value: " + step);
        }
    }

    public <R extends GraphQLRequestObject> Mono<R> execReactive(Class<R> r, Map<String, Object> params) throws GraphQLRequestExecutionException {
        if (this.getRequestType().equals((Object)RequestType.subscription)) {
            throw new GraphQLRequestExecutionException("This method may not be called for subscriptions");
        }
        Payload payload = this.getPayload(params);
        GraphQlClient.RequestSpec requestSpec = this.graphQlClient.document(payload.query);
        requestSpec.variables(payload.variables);
        requestSpec.operationName(payload.operationName);
        logger.trace("Executing query or mutation {}", (Object)payload.query);
        return requestSpec.execute().map(response -> {
            try {
                return this.extractResponseData(r, (ClientGraphQlResponse)response, payload);
            }
            catch (GraphQLRequestExecutionException e) {
                throw new GraphQLRequestExecutionUncheckedException(e);
            }
        });
    }

    public <R extends GraphQLRequestObject> R exec(Class<R> r, Map<String, Object> params) throws GraphQLRequestExecutionException {
        try {
            return (R)((GraphQLRequestObject)this.execReactive(r, params).block());
        }
        catch (GraphQLRequestExecutionUncheckedException e) {
            throw e.getGraphQLRequestExecutionException();
        }
    }

    private <R extends GraphQLRequestObject> R extractResponseData(Class<R> r, ClientGraphQlResponse response, Payload payload) throws GraphQLRequestExecutionException {
        GraphQLRequestObject ret = null;
        try {
            GraphQLJsonMapper objectMapper = this.getGraphQLObjectMapper();
            ret = (GraphQLRequestObject)objectMapper.treeToValue((Map)response.getData(), r);
            if (ret != null) {
                ret.setExtensions(objectMapper.valueToTree(response.getExtensions()));
            }
        }
        catch (JacksonException e) {
            throw new GraphQLRequestExecutionException("Error when executing query <" + payload.query + ">: " + e.getMessage(), e);
        }
        if (response.getErrors() != null && response.getErrors().size() > 0) {
            throw new GraphQLRequestExecutionException(response.getErrors(), ret, response);
        }
        return (R)ret;
    }

    public <R extends GraphQLRequestObject> Flux<R> execReactive(Map<String, Object> params, Class<R> subscriptionType) throws GraphQLRequestExecutionException {
        if (!this.requestType.equals((Object)RequestType.subscription)) {
            throw new GraphQLRequestExecutionException("This method may be called only for subscriptions");
        }
        if (this.subscription.getFields().size() != 1) {
            throw new GraphQLRequestExecutionException("This method may be called only for one subscription at a time, but there was " + this.subscription.getFields().size() + " subscriptions in this GraphQLRequest");
        }
        Payload payload = this.getPayload(params);
        GraphQlClient.RequestSpec requestSpec = this.graphQlClient.document(payload.query);
        if (payload.variables.size() > 0) {
            requestSpec.variables(payload.variables);
        }
        if (payload.operationName != null) {
            requestSpec.operationName(payload.operationName);
        }
        SubscriptionMessageConsumer msgConsumer = new SubscriptionMessageConsumer(subscriptionType);
        return requestSpec.executeSubscription().map(response -> msgConsumer.accept((ClientGraphQlResponse)response));
    }

    public <R extends GraphQLRequestObject, T> SubscriptionClient exec(Map<String, Object> params, final SubscriptionCallback<T> subscriptionCallback, Class<R> subscriptionType, Class<T> messageType) throws GraphQLRequestExecutionException {
        return new SubscriptionClientReactiveImpl(this.execReactive(params, subscriptionType).doOnSubscribe((Consumer)new Consumer<Subscription>(){

            @Override
            public void accept(Subscription t) {
                subscriptionCallback.onConnect();
            }
        }).subscribe(r -> {
            Object t = GraphqlUtils.graphqlUtils.invokeGetter(r, this.subscription.getFields().get(0).getName());
            subscriptionCallback.onMessage(t);
        }, err -> {
            if (err instanceof RuntimeException && (err.getCause() instanceof GraphQLRequestPreparationException || err.getCause() instanceof GraphQLRequestExecutionException)) {
                subscriptionCallback.onError(err.getCause());
            } else {
                subscriptionCallback.onError((Throwable)err);
            }
        }, new Runnable(){

            @Override
            public void run() {
                subscriptionCallback.onClose(0, null);
            }
        }));
    }

    private void addTypenameFields() throws GraphQLRequestPreparationException {
        if (this.query != null) {
            this.query.addTypenameFields();
        }
        if (this.mutation != null) {
            this.mutation.addTypenameFields();
        }
        if (this.subscription != null) {
            this.subscription.addTypenameFields();
        }
        for (Fragment f : this.fragments) {
            f.addTypenameFields();
        }
    }

    private void finishRequestPreparation() throws GraphQLRequestPreparationException {
        this.AddScalarFieldToEmptyNonScalarField(this.query);
        this.AddScalarFieldToEmptyNonScalarField(this.mutation);
        this.AddScalarFieldToEmptyNonScalarField(this.subscription);
        this.addTypenameFields();
    }

    private void AddScalarFieldToEmptyNonScalarField(QueryField field) throws GraphQLRequestPreparationException {
        block7: {
            if (field == null || field.isScalar()) break block7;
            if (field.fields.size() == 0 && field.fragments.size() == 0 && field.inlineFragments.size() == 0) {
                if (field.clazz.isInterface()) {
                    for (Method m : field.clazz.getDeclaredMethods()) {
                        GraphQLScalar graphQLScalar;
                        if (!m.getName().startsWith("get") || (graphQLScalar = m.getAnnotation(GraphQLScalar.class)) == null) continue;
                        field.fields.add(new QueryField(field.clazz, graphQLScalar.fieldName()));
                    }
                } else {
                    for (Field f : field.clazz.getDeclaredFields()) {
                        GraphQLScalar graphQLScalar = f.getAnnotation(GraphQLScalar.class);
                        if (graphQLScalar == null) continue;
                        field.fields.add(new QueryField(field.clazz, graphQLScalar.fieldName()));
                    }
                }
            } else {
                for (QueryField f : field.fields) {
                    this.AddScalarFieldToEmptyNonScalarField(f);
                }
            }
        }
    }

    public Payload getPayload(Map<String, Object> params) throws GraphQLRequestExecutionException {
        QueryField request;
        Payload payload = new Payload();
        StringBuilder sb = new StringBuilder();
        StringBuilder sbGraphQLVariables = new StringBuilder();
        for (Fragment fragment : this.fragments) {
            fragment.appendToGraphQLRequests(sb, params);
        }
        if (this.query != null) {
            request = this.query;
        } else if (this.mutation != null) {
            request = this.mutation;
        } else if (this.subscription != null) {
            request = this.subscription;
        } else {
            throw new GraphQLRequestExecutionException("[Internal error] no request has been initialized");
        }
        sb.append(request.name);
        if (this.requestName != null) {
            sb.append(" ").append(this.requestName);
        }
        String separator = "";
        for (InputParameter param : request.inputParameters) {
            int i;
            if (param.getType() != InputParameter.InputParameterType.GRAPHQL_VARIABLE) continue;
            sbGraphQLVariables.append(separator).append("$").append(param.getBindParameterName()).append(":");
            for (i = 0; i < param.getListDepth(); ++i) {
                sbGraphQLVariables.append("[");
            }
            sbGraphQLVariables.append(param.getGraphQLTypeName()).append(param.isItemMandatory() ? "!" : "");
            for (i = 0; i < param.getListDepth(); ++i) {
                sbGraphQLVariables.append("]");
            }
            sbGraphQLVariables.append(param.isMandatory() ? "!" : "");
            if (params != null && params.containsKey(param.getBindParameterName())) {
                payload.variables.put(param.getBindParameterName(), param.getValueForGraphqlQuery(params));
            }
            if (param.getDefaultValue() != null) {
                sbGraphQLVariables.append("=");
                sbGraphQLVariables.append(param.getDefaultValueForGraphqlQuery());
            }
            separator = ",";
        }
        String graphQLVariables = sbGraphQLVariables.toString();
        if (graphQLVariables.length() > 0) {
            sb.append("(").append(graphQLVariables).append(")");
        }
        request.appendToGraphQLRequests(sb, params, false);
        payload.query = sb.toString();
        return payload;
    }

    public GraphQLJsonMapper getGraphQLObjectMapper() {
        return new GraphQLJsonMapper(this.registriesInitializer.getPackageName(), this.aliasFields, this.registriesInitializer.getSchema());
    }

    public String getGraphQLRequest() {
        return this.graphQLRequest;
    }

    private QueryField getQueryContext() throws GraphQLRequestPreparationException {
        return new QueryField(this.registriesInitializer.getQueryRootResponseClass(), "query");
    }

    private QueryField getMutationContext() throws GraphQLRequestPreparationException {
        return new QueryField(this.registriesInitializer.getMutationRootResponseClass(), "mutation");
    }

    private QueryField getSubscriptionContext() throws GraphQLRequestPreparationException {
        return new QueryField(this.registriesInitializer.getSubscriptionRootResponseClass(), "subscription");
    }

    public QueryField getQuery() {
        return this.query;
    }

    public QueryField getMutation() {
        return this.mutation;
    }

    public QueryField getSubscription() {
        return this.subscription;
    }

    public List<Fragment> getFragments() {
        return this.fragments;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public String getRequestName() {
        return this.requestName;
    }

    protected static void logExecution(RequestType requestType, String queryMutationTypeName, Map<String, Object> parameters) {
        if (logger.isTraceEnabled()) {
            if (parameters == null) {
                logger.trace("Executing of " + requestType.toString() + " without parameters");
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("Executing of root ").append(requestType.toString()).append("mutation with parameters: ");
                boolean addComma = false;
                for (String key : parameters.keySet()) {
                    sb.append(key).append(":").append(parameters.get(key));
                    if (addComma) {
                        sb.append(", ");
                    }
                    addComma = true;
                }
                logger.trace(sb.toString());
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Executing of {} '{}'", (Object)requestType.toString(), (Object)queryMutationTypeName);
        }
    }

    private static enum Step {
        NAME,
        TYPE;

    }

    public static final class Payload {
        String query = null;
        Map<String, Object> variables = new HashMap<String, Object>();
        String operationName = null;

        public String getQuery() {
            return this.query;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public String getOperationName() {
            return this.operationName;
        }
    }

    private class SubscriptionMessageConsumer<R extends GraphQLRequestObject> {
        private final Class<R> subscriptionType;

        SubscriptionMessageConsumer(Class<R> subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public R accept(ClientGraphQlResponse response) {
            GraphQLRequestObject ret = null;
            try {
                GraphQLJsonMapper objectMapper = AbstractGraphQLRequest.this.getGraphQLObjectMapper();
                ret = (GraphQLRequestObject)objectMapper.treeToValue((Map)response.getData(), this.subscriptionType);
                ret.setExtensions(objectMapper.valueToTree(response.getExtensions()));
            }
            catch (JacksonException e) {
                GraphQLRequestExecutionException ex = new GraphQLRequestExecutionException("Error when receiving notifications for subscription <" + AbstractGraphQLRequest.this.graphQLRequest + ">: " + e.getMessage(), e);
                throw new GraphQLRequestExecutionUncheckedException(ex);
            }
            if (!response.isValid()) {
                throw new GraphQLRequestExecutionUncheckedException(new GraphQLRequestExecutionException(response.getErrors(), ret, response));
            }
            return (R)ret;
        }
    }
}

