/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.metrics;

import com.wavefront.common.TaggedMetricName;
import com.wavefront.metrics.JsonMetricsGenerator;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import com.yammer.metrics.reporting.AbstractPollingReporter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;

public class JsonMetricsReporter
extends AbstractPollingReporter {
    private static final Logger logger = Logger.getLogger(JsonMetricsReporter.class.getCanonicalName());
    private final boolean includeVMMetrics;
    private final String table;
    private final String sunnylabsHost;
    private final String host;
    private final Map<String, String> tags;
    private final Counter errors;
    private final boolean clearMetrics;
    private Timer latency;
    private Counter reports;
    private final long START_TIME = System.currentTimeMillis();
    private final Gauge<Long> serverUptime = Metrics.newGauge((MetricName)new TaggedMetricName("service", "uptime"), (Gauge)new Gauge<Long>(){

        public Long value() {
            return System.currentTimeMillis() - JsonMetricsReporter.this.START_TIME;
        }
    });

    public JsonMetricsReporter(MetricsRegistry registry, String table, String sunnylabsHost, Map<String, String> tags, boolean clearMetrics) throws UnknownHostException {
        this(registry, true, table, sunnylabsHost, tags, clearMetrics);
    }

    public JsonMetricsReporter(MetricsRegistry registry, boolean includeVMMetrics, String table, String sunnylabsHost, Map<String, String> tags, boolean clearMetrics) throws UnknownHostException {
        super(registry, "json-metrics-reporter");
        this.includeVMMetrics = includeVMMetrics;
        this.tags = tags;
        this.table = table;
        this.sunnylabsHost = sunnylabsHost;
        this.clearMetrics = clearMetrics;
        this.host = InetAddress.getLocalHost().getHostName();
        this.latency = Metrics.newTimer((MetricName)new MetricName("jsonreporter", "jsonreporter", "latency"), (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.reports = Metrics.newCounter((MetricName)new MetricName("jsonreporter", "jsonreporter", "reports"));
        this.errors = Metrics.newCounter((MetricName)new MetricName("jsonreporter", "jsonreporter", "errors"));
    }

    public void run() {
        try {
            this.reportMetrics();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Uncaught exception in reportMetrics loop", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMetrics() {
        TimerContext time = this.latency.time();
        try {
            UriBuilder builder = UriBuilder.fromUri((URI)new URI("https", this.sunnylabsHost, "/report/metrics", null));
            builder.queryParam("h", new Object[]{this.host});
            builder.queryParam("t", new Object[]{this.table});
            for (Map.Entry<String, String> tag : this.tags.entrySet()) {
                builder.queryParam(tag.getKey(), new Object[]{tag.getValue()});
            }
            URL http = builder.build(new Object[0]).toURL();
            System.out.println("Reporting started to: " + http);
            HttpURLConnection urlc = (HttpURLConnection)http.openConnection();
            urlc.setDoOutput(true);
            urlc.setReadTimeout(60000);
            urlc.setConnectTimeout(60000);
            urlc.addRequestProperty("Content-Type", "application/json");
            OutputStream outputStream = urlc.getOutputStream();
            JsonMetricsGenerator.generateJsonMetrics(outputStream, this.getMetricsRegistry(), this.includeVMMetrics, true, this.clearMetrics);
            outputStream.close();
            System.out.println("Reporting complete: " + urlc.getResponseCode());
            this.reports.inc();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            this.errors.inc();
        }
        finally {
            time.stop();
        }
    }
}

