/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlMetaConst;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlMetaIdent;
import org.sqlproc.engine.impl.SqlMetaText;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlUtils;

class SqlMetaIfItem
implements SqlMetaElement {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    List<SqlMetaElement> elements = new ArrayList<SqlMetaElement>();

    SqlMetaIfItem() {
    }

    void addElement(SqlMetaElement element) {
        this.elements.add(element);
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult();
        result.addFalse();
        result.setSql(new StringBuilder());
        boolean like = false;
        boolean onlyText = true;
        boolean skipNextText = false;
        for (SqlMetaElement item : this.elements) {
            SqlProcessResult itemResult;
            if (item instanceof SqlMetaIdent || item instanceof SqlMetaConst || item instanceof SqlMetaIfItem) {
                onlyText = false;
            }
            if (!(itemResult = item.process(ctx)).isAdd() || skipNextText && item instanceof SqlMetaText) continue;
            if (item instanceof SqlMetaIdent || item instanceof SqlMetaConst || item instanceof SqlMetaIfItem) {
                result.addTrue();
            }
            result.getSql().append((CharSequence)itemResult.getSql());
            result.addInputValues(itemResult.getInputValues());
            result.addMappedInputValues(itemResult.getMappedInputValues());
            result.addOutputValues(itemResult.getOutputValues());
            result.addIdentities(itemResult.getIdentities());
            if (SqlProcessContext.isFeature("SURROUND_QUERY_LIKE") && item instanceof SqlMetaIdent && like) {
                for (String ident : itemResult.getInputValues()) {
                    itemResult.getInputValue(ident).setLike(SqlProcessContext.getFeature("WILDCARD_CHARACTER"), SqlProcessContext.getFeatureAsInt("SURROUND_QUERY_MIN_LEN"));
                }
            } else {
                like = item instanceof SqlMetaText && SqlProcessContext.isFeature("SURROUND_QUERY_LIKE") && itemResult.getSql().toString().trim().toLowerCase().endsWith(SqlProcessContext.getFeature("LIKE_STRING"));
            }
            skipNextText = result.isSkipNextText();
        }
        if (onlyText && !SqlUtils.isEmpty(result.getSql())) {
            result.addTrue();
        }
        return result;
    }
}

