/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.dom.DOMExceptionImpl;
import com.gargoylesoftware.css.parser.AbstractLocatable;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.CSSParseException;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.parser.media.MediaQuery;
import com.gargoylesoftware.css.parser.media.MediaQueryList;
import com.gargoylesoftware.css.util.LangUtils;
import com.gargoylesoftware.css.util.ThrowCssExceptionErrorHandler;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.DOMException;

public class MediaListImpl
extends AbstractLocatable
implements Serializable {
    private List<MediaQuery> mediaQueries_ = new ArrayList<MediaQuery>(10);

    public MediaListImpl(MediaQueryList mediaList) {
        this.setMediaList(mediaList);
        if (mediaList != null) {
            this.setLocator(mediaList.getLocator());
        }
    }

    public String getMediaText() {
        StringBuilder sb = new StringBuilder("");
        boolean isNotFirst = false;
        for (MediaQuery mediaQuery : this.mediaQueries_) {
            if (isNotFirst) {
                sb.append(", ");
            } else {
                isNotFirst = true;
            }
            sb.append(mediaQuery.toString());
        }
        return sb.toString();
    }

    public void setMediaText(String mediaText) throws DOMException {
        InputSource source = new InputSource(new StringReader(mediaText));
        try {
            CSSOMParser parser = new CSSOMParser();
            parser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            MediaQueryList sml = parser.parseMedia(source);
            this.setMediaList(sml);
        }
        catch (CSSParseException e) {
            throw new DOMException(12, e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new DOMException(8, e.getLocalizedMessage());
        }
    }

    public int getLength() {
        return this.mediaQueries_.size();
    }

    public MediaQuery mediaQuery(int index) {
        if (index < 0 || index >= this.mediaQueries_.size()) {
            return null;
        }
        return this.mediaQueries_.get(index);
    }

    public void deleteMedium(String oldMedium) throws DOMException {
        for (MediaQuery mediaQuery : this.mediaQueries_) {
            String str = mediaQuery.getMedia();
            if (!str.equalsIgnoreCase(oldMedium)) continue;
            this.mediaQueries_.remove(mediaQuery);
            return;
        }
        throw new DOMExceptionImpl(8, 17);
    }

    public void appendMedium(String newMedium) throws DOMException {
        this.mediaQueries_.add(new MediaQuery(newMedium));
    }

    public String toString() {
        return this.getMediaText();
    }

    public void setMedia(List<String> media) {
        this.mediaQueries_.clear();
        for (String medium : media) {
            this.mediaQueries_.add(new MediaQuery(medium));
        }
    }

    private void setMediaList(MediaQueryList mediaList) {
        if (mediaList != null) {
            for (int i = 0; i < mediaList.getLength(); ++i) {
                this.mediaQueries_.add(mediaList.mediaQuery(i));
            }
        }
    }

    private boolean equalsMedia(MediaListImpl ml) {
        if (ml == null || this.getLength() != ml.getLength()) {
            return false;
        }
        int i = 0;
        for (MediaQuery mediaQuery : this.mediaQueries_) {
            String m2;
            String m1 = mediaQuery.getMedia();
            if (!LangUtils.equals(m1, m2 = ml.mediaQuery(i).getMedia())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MediaListImpl)) {
            return false;
        }
        MediaListImpl ml = (MediaListImpl)obj;
        return super.equals(obj) && this.equalsMedia(ml);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.mediaQueries_);
        return hash;
    }
}

