/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.copy_factory;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.HttpRequestOptions;
import cloud.metaapi.sdk.clients.MetaApiClient;
import cloud.metaapi.sdk.clients.TimeoutException;
import cloud.metaapi.sdk.clients.copy_factory.models.CopyFactoryAccount;
import cloud.metaapi.sdk.clients.copy_factory.models.CopyFactoryAccountUpdate;
import cloud.metaapi.sdk.clients.copy_factory.models.CopyFactoryStrategy;
import cloud.metaapi.sdk.clients.copy_factory.models.CopyFactoryStrategyUpdate;
import cloud.metaapi.sdk.clients.copy_factory.models.ResynchronizationTask;
import cloud.metaapi.sdk.clients.copy_factory.models.StrategyId;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.commons.lang3.RandomStringUtils;

public class ConfigurationClient
extends MetaApiClient {
    public ConfigurationClient(HttpClient httpClient, String token) {
        this(httpClient, token, "agiliumtrade.agiliumtrade.ai");
    }

    public ConfigurationClient(HttpClient httpClient, String token, String domain) {
        super(httpClient, token, domain);
        this.host = "https://trading-api-v1." + domain;
    }

    public CompletableFuture<StrategyId> generateStrategyId() {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("generateStrategyId");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/configuration/unused-strategy-id", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, StrategyId.class);
    }

    public String generateAccountId() {
        return RandomStringUtils.randomAlphanumeric((int)64);
    }

    public CompletableFuture<List<CopyFactoryAccount>> getAccounts() {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getAccounts");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/configuration/accounts", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, CopyFactoryAccount[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<Void> updateAccount(String id, CopyFactoryAccountUpdate account) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("updateAccount");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/configuration/accounts/" + id, HttpRequestOptions.Method.PUT);
        opts.getHeaders().put("auth-token", this.token);
        opts.setBody(account);
        return this.httpClient.request(opts).thenApply(response -> null);
    }

    public CompletableFuture<Void> removeAccount(String id) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("removeAccount");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/configuration/accounts/" + id, HttpRequestOptions.Method.DELETE);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.request(opts).thenApply(response -> null);
    }

    public CompletableFuture<List<CopyFactoryStrategy>> getStrategies() {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getStrategies");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/configuration/strategies", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, CopyFactoryStrategy[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<Void> updateStrategy(String id, CopyFactoryStrategyUpdate strategy) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("updateStrategy");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/configuration/strategies/" + id, HttpRequestOptions.Method.PUT);
        opts.getHeaders().put("auth-token", this.token);
        opts.setBody(strategy);
        return this.httpClient.request(opts).thenApply(response -> null);
    }

    public CompletableFuture<Void> removeStrategy(String id) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("removeStrategy");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/configuration/strategies/" + id, HttpRequestOptions.Method.DELETE);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.request(opts).thenApply(response -> null);
    }

    public CompletableFuture<List<ResynchronizationTask>> getActiveResynchronizationTasks(String connectionId) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getActiveResynchronizationTasks");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/configuration/connections/" + connectionId + "/active-resynchronization-tasks", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, ResynchronizationTask[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<Void> waitResynchronizationTasksCompleted(String connectionId) {
        return this.waitResynchronizationTasksCompleted(connectionId, null, null);
    }

    public CompletableFuture<Void> waitResynchronizationTasksCompleted(String connectionId, Integer timeoutInSeconds, Integer intervalInMilliseconds) {
        return CompletableFuture.runAsync(() -> {
            try {
                long startTime = Instant.now().getEpochSecond();
                long timeoutTime = startTime + (long)(timeoutInSeconds != null ? timeoutInSeconds : 300);
                List<ResynchronizationTask> tasks = this.getActiveResynchronizationTasks(connectionId).get();
                while (!tasks.isEmpty() && timeoutTime > Instant.now().getEpochSecond()) {
                    Thread.sleep(intervalInMilliseconds != null ? (long)intervalInMilliseconds.intValue() : 1000L);
                    tasks = this.getActiveResynchronizationTasks(connectionId).get();
                }
                if (!tasks.isEmpty()) {
                    throw new TimeoutException("Timed out waiting for resynchronization tasks for account " + connectionId + " to be completed");
                }
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }
}

