/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.HttpRequestOptions;
import cloud.metaapi.sdk.clients.MetaApiClient;
import cloud.metaapi.sdk.clients.meta_api.models.NewProvisioningProfileDto;
import cloud.metaapi.sdk.clients.meta_api.models.ProvisioningProfileDto;
import cloud.metaapi.sdk.clients.meta_api.models.ProvisioningProfileIdDto;
import cloud.metaapi.sdk.clients.meta_api.models.ProvisioningProfileUpdateDto;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class ProvisioningProfileClient
extends MetaApiClient {
    public ProvisioningProfileClient(HttpClient httpClient, String token) {
        super(httpClient, token);
    }

    public ProvisioningProfileClient(HttpClient httpClient, String token, String domain) {
        super(httpClient, token, domain);
    }

    public CompletableFuture<List<ProvisioningProfileDto>> getProvisioningProfiles(Integer version, String status) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getProvisioningProfiles");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/provisioning-profiles", HttpRequestOptions.Method.GET);
        if (version != null) {
            opts.getQueryParameters().put("version", version);
        }
        if (status != null) {
            opts.getQueryParameters().put("status", status);
        }
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, ProvisioningProfileDto[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<ProvisioningProfileDto> getProvisioningProfile(String id) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getProvisioningProfile");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/provisioning-profiles/" + id, HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, ProvisioningProfileDto.class);
    }

    public CompletableFuture<ProvisioningProfileIdDto> createProvisioningProfile(NewProvisioningProfileDto provisioningProfile) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("createProvisioningProfile");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/provisioning-profiles", HttpRequestOptions.Method.POST);
        opts.getHeaders().put("auth-token", this.token);
        opts.setBody(provisioningProfile);
        return this.httpClient.requestJson(opts, ProvisioningProfileIdDto.class);
    }

    public CompletableFuture<Void> uploadProvisioningProfileFile(String provisioningProfileId, String fileName, String filePath) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.uploadProvisioningProfileFile(provisioningProfileId, new HttpRequestOptions.FileStreamField(new FileInputStream(filePath), fileName)).join();
            }
            catch (FileNotFoundException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Void> uploadProvisioningProfileFile(String provisioningProfileId, String fileName, InputStream fileContents) {
        return this.uploadProvisioningProfileFile(provisioningProfileId, new HttpRequestOptions.FileStreamField(fileContents, fileName));
    }

    public CompletableFuture<Void> deleteProvisioningProfile(String id) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("deleteProvisioningProfile");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/provisioning-profiles/" + id, HttpRequestOptions.Method.DELETE);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.request(opts).thenApply(body -> null);
    }

    public CompletableFuture<Void> updateProvisioningProfile(String id, ProvisioningProfileUpdateDto provisioningProfile) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("updateProvisioningProfile");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/provisioning-profiles/" + id, HttpRequestOptions.Method.PUT);
        opts.getHeaders().put("auth-token", this.token);
        opts.setBody(provisioningProfile);
        return this.httpClient.request(opts).thenApply(body -> null);
    }

    private CompletableFuture<Void> uploadProvisioningProfileFile(String provisioningProfileId, HttpRequestOptions.FileStreamField file) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("uploadProvisioningProfileFile");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/provisioning-profiles/" + provisioningProfileId + "/" + file.getFileName(), HttpRequestOptions.Method.PUT);
        HashMap<String, Object> formData = new HashMap<String, Object>();
        formData.put("file", file);
        opts.setBody(formData);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.request(opts).thenApply(body -> null);
    }
}

