/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.TimeoutException;
import cloud.metaapi.sdk.clients.error_handler.NotFoundException;
import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.meta_api.MetatraderAccountClient;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountDto;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountUpdateDto;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.meta_api.ConnectionRegistry;
import cloud.metaapi.sdk.meta_api.HistoryFileManager;
import cloud.metaapi.sdk.meta_api.HistoryStorage;
import cloud.metaapi.sdk.meta_api.MetaApiConnection;
import cloud.metaapi.sdk.util.ServiceProvider;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;

public class MetatraderAccount {
    private MetatraderAccountDto data;
    private MetatraderAccountClient metatraderAccountClient;
    private ConnectionRegistry connectionRegistry;

    public MetatraderAccount(MetatraderAccountDto data, MetatraderAccountClient metatraderAccountClient, MetaApiWebsocketClient metaApiWebsocketClient, ConnectionRegistry connectionRegistry) {
        this.data = data;
        this.metatraderAccountClient = metatraderAccountClient;
        this.connectionRegistry = connectionRegistry;
    }

    public String getId() {
        return this.data._id;
    }

    public String getName() {
        return this.data.name;
    }

    public String getType() {
        return this.data.type;
    }

    public String getLogin() {
        return this.data.login;
    }

    public String getServer() {
        return this.data.server;
    }

    public String getProvisioningProfileId() {
        return this.data.provisioningProfileId;
    }

    public String getApplication() {
        return this.data.application;
    }

    public int getMagic() {
        return this.data.magic;
    }

    public MetatraderAccountDto.DeploymentState getState() {
        return this.data.state;
    }

    public MetatraderAccountDto.ConnectionStatus getConnectionStatus() {
        return this.data.connectionStatus;
    }

    public String getAccessToken() {
        return this.data.accessToken;
    }

    public boolean isManualTrades() {
        return this.data.manualTrades;
    }

    public CompletableFuture<Void> reload() {
        return this.metatraderAccountClient.getAccount(this.getId()).thenAccept(account -> {
            this.data = account;
        });
    }

    public CompletableFuture<Void> remove() {
        return CompletableFuture.supplyAsync(() -> {
            this.connectionRegistry.remove(this.getId());
            try {
                block5: {
                    this.metatraderAccountClient.deleteAccount(this.getId()).get();
                    HistoryFileManager fileManager = ServiceProvider.createHistoryFileManager(this.getId(), "MetaApi", null);
                    fileManager.deleteStorageFromDisk().get();
                    if (!this.getType().equals("self-hosted")) {
                        try {
                            this.reload().get();
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() instanceof NotFoundException) break block5;
                            throw e.getCause();
                        }
                    }
                }
                return null;
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Void> deploy() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        CompletableFuture.runAsync(() -> {
            try {
                this.metatraderAccountClient.deployAccount(this.getId()).get();
                this.reload().get();
                result.complete(null);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<Void> undeploy() {
        return CompletableFuture.runAsync(() -> {
            this.connectionRegistry.remove(this.getId());
            this.metatraderAccountClient.undeployAccount(this.getId()).join();
            this.reload().join();
        });
    }

    public CompletableFuture<Void> redeploy() {
        return CompletableFuture.runAsync(() -> {
            this.metatraderAccountClient.redeployAccount(this.getId()).join();
            this.reload().join();
        });
    }

    public CompletableFuture<Void> waitDeployed(Integer timeoutInSeconds, Integer intervalInMilliseconds) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        CompletableFuture.runAsync(() -> {
            long startTime = Instant.now().getEpochSecond();
            long timeoutTime = startTime + (long)(timeoutInSeconds != null ? timeoutInSeconds : 300);
            try {
                this.reload().get();
                while (this.getState() != MetatraderAccountDto.DeploymentState.DEPLOYED && timeoutTime > Instant.now().getEpochSecond()) {
                    Thread.sleep(intervalInMilliseconds != null ? (long)intervalInMilliseconds.intValue() : 1000L);
                    this.reload().get();
                }
                if (this.getState() != MetatraderAccountDto.DeploymentState.DEPLOYED) {
                    throw new TimeoutException("Timed out waiting for account " + this.getId() + " to be deployed");
                }
                result.complete(null);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<Void> waitUndeployed(Integer timeoutInSeconds, Integer intervalInMilliseconds) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        CompletableFuture.runAsync(() -> {
            long startTime = Instant.now().getEpochSecond();
            long timeoutTime = startTime + (long)(timeoutInSeconds != null ? timeoutInSeconds : 300);
            try {
                this.reload().get();
                while (this.getState() != MetatraderAccountDto.DeploymentState.UNDEPLOYED && timeoutTime > Instant.now().getEpochSecond()) {
                    Thread.sleep(intervalInMilliseconds != null ? (long)intervalInMilliseconds.intValue() : 1000L);
                    this.reload().get();
                }
                if (this.getState() != MetatraderAccountDto.DeploymentState.UNDEPLOYED) {
                    throw new TimeoutException("Timed out waiting for account " + this.getId() + " to be undeployed");
                }
                result.complete(null);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<Void> waitRemoved(Integer timeoutInSeconds, Integer intervalInMilliseconds) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        CompletableFuture.runAsync(() -> {
            long startTime = Instant.now().getEpochSecond();
            long timeoutTime = startTime + (long)(timeoutInSeconds != null ? timeoutInSeconds : 300);
            try {
                this.reload().get();
                while (timeoutTime > Instant.now().getEpochSecond()) {
                    Thread.sleep(intervalInMilliseconds != null ? (long)intervalInMilliseconds.intValue() : 1000L);
                    this.reload().get();
                }
                throw new TimeoutException("Timed out waiting for account " + this.getId() + " to be deleted");
            }
            catch (Exception e) {
                if (e.getCause() instanceof NotFoundException) {
                    result.complete(null);
                } else {
                    result.completeExceptionally(e);
                }
                return;
            }
        });
        return result;
    }

    public CompletableFuture<Void> waitConnected() {
        return this.waitConnected(null, null);
    }

    public CompletableFuture<Void> waitConnected(Integer timeoutInSeconds, Integer intervalInMilliseconds) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        CompletableFuture.runAsync(() -> {
            long startTime = Instant.now().getEpochSecond();
            long timeoutTime = startTime + (long)(timeoutInSeconds != null ? timeoutInSeconds : 300);
            try {
                this.reload().get();
                while (this.getConnectionStatus() != MetatraderAccountDto.ConnectionStatus.CONNECTED && timeoutTime > Instant.now().getEpochSecond()) {
                    Thread.sleep(intervalInMilliseconds != null ? (long)intervalInMilliseconds.intValue() : 1000L);
                    this.reload().get();
                }
                if (this.getConnectionStatus() != MetatraderAccountDto.ConnectionStatus.CONNECTED) {
                    throw new TimeoutException("Timed out waiting for account " + this.getId() + " to connect to the broker");
                }
                result.complete(null);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetaApiConnection> connect() {
        return this.connect(null, null);
    }

    public CompletableFuture<MetaApiConnection> connect(HistoryStorage historyStorage) {
        return this.connect(historyStorage, null);
    }

    public CompletableFuture<MetaApiConnection> connect(HistoryStorage historyStorage, IsoTime historyStartTime) {
        return this.connectionRegistry.connect(this, historyStorage, historyStartTime);
    }

    public CompletableFuture<Void> update(MetatraderAccountUpdateDto account) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        CompletableFuture.runAsync(() -> {
            try {
                this.metatraderAccountClient.updateAccount(this.getId(), account).get();
                this.reload().get();
                result.complete(null);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }
}

