/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.meta_api.MetatraderAccountClient;
import cloud.metaapi.sdk.clients.meta_api.models.AccountsFilter;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountDto;
import cloud.metaapi.sdk.clients.meta_api.models.NewMetatraderAccountDto;
import cloud.metaapi.sdk.meta_api.ConnectionRegistry;
import cloud.metaapi.sdk.meta_api.MetatraderAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class MetatraderAccountApi {
    private MetatraderAccountClient metatraderAccountClient;
    private MetaApiWebsocketClient metaApiWebsocketClient;
    private ConnectionRegistry connectionRegistry;

    public MetatraderAccountApi(MetatraderAccountClient metatraderAccountClient, MetaApiWebsocketClient metaApiWebsocketClient, ConnectionRegistry connectionRegistry) {
        this.metatraderAccountClient = metatraderAccountClient;
        this.metaApiWebsocketClient = metaApiWebsocketClient;
        this.connectionRegistry = connectionRegistry;
    }

    public CompletableFuture<List<MetatraderAccount>> getAccounts() {
        return this.getAccounts(null);
    }

    public CompletableFuture<List<MetatraderAccount>> getAccounts(AccountsFilter accountsFilter) {
        return this.metatraderAccountClient.getAccounts(accountsFilter).thenApply(accounts -> {
            ArrayList result = new ArrayList();
            accounts.forEach(accountDto -> result.add(new MetatraderAccount((MetatraderAccountDto)accountDto, this.metatraderAccountClient, this.metaApiWebsocketClient, this.connectionRegistry)));
            return result;
        });
    }

    public CompletableFuture<MetatraderAccount> getAccount(String accountId) {
        return this.metatraderAccountClient.getAccount(accountId).thenApply(accountDto -> new MetatraderAccount((MetatraderAccountDto)accountDto, this.metatraderAccountClient, this.metaApiWebsocketClient, this.connectionRegistry));
    }

    public CompletableFuture<MetatraderAccount> getAccountByToken() {
        return this.metatraderAccountClient.getAccountByToken().thenApply(accountDto -> new MetatraderAccount((MetatraderAccountDto)accountDto, this.metatraderAccountClient, this.metaApiWebsocketClient, this.connectionRegistry));
    }

    public CompletableFuture<MetatraderAccount> createAccount(NewMetatraderAccountDto account) {
        return this.metatraderAccountClient.createAccount(account).thenApply(id -> {
            try {
                return this.getAccount(id.id).get();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }
}

