/*
 * Decompiled with CFR 0.152.
 */
package e.java;

import e.java.E;
import e.java.ThrowingSupplier;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class Maybe<A> {
    private final E e;
    private final A value;

    private Maybe(E e, A a) {
        this.e = e;
        this.value = a;
    }

    protected Maybe(E e) {
        if (e == null) {
            throw new IllegalArgumentException("E cannot be null!");
        }
        this.e = e;
        this.value = null;
    }

    protected Maybe(A a) {
        if (a == null) {
            throw new IllegalArgumentException("Value cannot be null!");
        }
        this.e = null;
        this.value = a;
    }

    public static <A> Maybe<A> failure(E e) {
        return new Failure(e);
    }

    public static <A> Maybe<A> success(A a) {
        return new Success<A>(a);
    }

    public static Maybe<Void> unit() {
        return new Maybe<Object>(null, null);
    }

    public static <A> Maybe<A> catching(ThrowingSupplier<A> throwingSupplier, Function<Throwable, E> function) {
        try {
            return new Success<A>(throwingSupplier.get());
        }
        catch (Throwable throwable) {
            return new Failure(function.apply(throwable));
        }
    }

    public static <A> Maybe<A> catchingMaybe(ThrowingSupplier<Maybe<A>> throwingSupplier, Function<Throwable, E> function) {
        try {
            return throwingSupplier.get();
        }
        catch (Throwable throwable) {
            return new Failure(function.apply(throwable));
        }
    }

    public static <A> Maybe<A> nullable(A a, Supplier<E> supplier) {
        return a == null ? new Failure(supplier.get()) : new Success<A>(a);
    }

    public boolean isSuccess() {
        return this.e == null;
    }

    public Optional<E> eOptional() {
        return Optional.ofNullable(this.e);
    }

    public Optional<A> valueOptional() {
        return Optional.ofNullable(this.value);
    }

    public <B> Maybe<B> map(Function<A, B> function) {
        return this.flatMap(object -> new Success(function.apply(object)));
    }

    public <B> Maybe<B> flatMap(Function<A, Maybe<B>> function) {
        return !this.isSuccess() ? new Failure(this.e) : function.apply(this.value);
    }

    public <B> B fold(Function<E, B> function, Function<A, B> function2) {
        return !this.isSuccess() ? function.apply(this.e) : function2.apply(this.value);
    }

    public A getOrElse(A a) {
        return (A)this.fold(e -> a, object -> object);
    }

    public Maybe<A> orElse(Maybe<A> maybe) {
        return !this.isSuccess() ? maybe : this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Maybe)) {
            return false;
        }
        Maybe maybe = (Maybe)object;
        return Objects.equals((Object)this.e, (Object)maybe.e) && Objects.equals(this.value, maybe.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.e, this.value});
    }

    public String toString() {
        return this.isSuccess() ? (this.value == null ? "unit" : this.value.toString()) : this.e.toString();
    }

    private static final class Success<A>
    extends Maybe<A> {
        public Success(A a) {
            super(a);
        }
    }

    private static final class Failure<A>
    extends Maybe<A> {
        public Failure(E e) {
            super(e);
        }
    }
}

