/*
 * Decompiled with CFR 0.152.
 */
package e.java;

import e.java.E;
import e.java.EException;
import e.java.UnsafeSupplier;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface EOr<A> {
    public static final EOr<Void> unit = new Success<Object>(null);
    public static final E filteredError = E.fromName("filtered").message("Condition does not hold!");

    default public boolean hasError() {
        return this instanceof Failure;
    }

    default public boolean hasValue() {
        return this instanceof Success;
    }

    default public Optional<E> error() {
        if (this.hasValue()) {
            return Optional.empty();
        }
        E e = ((Failure)this).e;
        return Optional.of(e);
    }

    default public Optional<A> value() {
        if (this.hasError()) {
            return Optional.empty();
        }
        Object a = ((Success)this).a;
        return Optional.of(a);
    }

    default public <B> EOr<B> map(Function<A, B> function) {
        if (this.hasError()) {
            E e = ((Failure)this).e;
            return new Failure(e);
        }
        Object a = ((Success)this).a;
        B b = function.apply(a);
        return new Success<B>(b);
    }

    default public <B> EOr<B> flatMap(Function<A, EOr<B>> function) {
        if (this.hasError()) {
            E e = ((Failure)this).e;
            return new Failure(e);
        }
        Object a = ((Success)this).a;
        return function.apply(a);
    }

    default public EOr<A> mapError(Function<E, E> function) {
        if (this.hasValue()) {
            return this;
        }
        E e = ((Failure)this).e;
        E e2 = function.apply(e);
        return new Failure(e2);
    }

    default public EOr<A> flatMapError(Function<E, EOr<A>> function) {
        if (this.hasValue()) {
            return this;
        }
        E e = ((Failure)this).e;
        return function.apply(e);
    }

    default public <B> B fold(Function<E, B> function, Function<A, B> function2) {
        if (this.hasError()) {
            E e = ((Failure)this).e;
            return function.apply(e);
        }
        Object a = ((Success)this).a;
        return function2.apply(a);
    }

    default public A getOrElse(Supplier<A> supplier) {
        if (this.hasValue()) {
            return ((Success)this).a;
        }
        return supplier.get();
    }

    default public EOr<A> orElse(Supplier<EOr<A>> supplier) {
        if (this.hasValue()) {
            return this;
        }
        return supplier.get();
    }

    default public <B> EOr<B> andThen(Supplier<EOr<B>> supplier) {
        if (this.hasError()) {
            E e = ((Failure)this).e;
            return new Failure(e);
        }
        return supplier.get();
    }

    default public EOr<A> onError(Consumer<E> consumer) {
        if (this.hasError()) {
            E e = ((Failure)this).e;
            consumer.accept(e);
        }
        return this;
    }

    default public EOr<A> onValue(Consumer<A> consumer) {
        if (this.hasValue()) {
            Object a = ((Success)this).a;
            consumer.accept(a);
        }
        return this;
    }

    default public EOr<A> forEach(Consumer<A> consumer) {
        return this.onValue(consumer);
    }

    default public EOr<A> filter(Function<A, Boolean> function, Function<A, E> function2) {
        if (this.hasError()) {
            return this;
        }
        Object a = ((Success)this).a;
        if (function.apply(a).booleanValue()) {
            return this;
        }
        return function2.apply(a).toEOr();
    }

    default public EOr<A> filter(Function<A, Boolean> function) {
        return this.filter(function, object -> filteredError.data("value", object));
    }

    public static <A> EOr<A> from(E e) {
        return new Failure(e);
    }

    public static <A> EOr<A> from(A a) {
        return new Success<A>(a);
    }

    public static <A> EOr<A> fromNullable(A a, Supplier<E> supplier) {
        return a == null ? new Failure(supplier.get()) : new Success<A>(a);
    }

    public static <A> EOr<A> fromOptional(Optional<A> optional, Supplier<E> supplier) {
        return !optional.isPresent() ? new Failure(supplier.get()) : new Success<A>(optional.get());
    }

    public static <A> EOr<A> catching(UnsafeSupplier<A> unsafeSupplier, Function<Throwable, E> function) {
        try {
            return new Success<A>(unsafeSupplier.get());
        }
        catch (EException eException) {
            return new Failure(eException.e);
        }
        catch (Throwable throwable) {
            return new Failure(function.apply(throwable));
        }
    }

    public static final class Failure<A>
    implements EOr<A> {
        private final E e;

        public Failure(E e) {
            if (e == null) {
                throw new IllegalArgumentException("E cannot be null!");
            }
            this.e = e;
        }

        public E e() {
            return this.e;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Failure)) {
                return false;
            }
            Failure failure = (Failure)object;
            return this.e.equals(failure.e);
        }

        public int hashCode() {
            return Objects.hash(this.e);
        }

        public String toString() {
            return this.e.toString();
        }
    }

    public static final class Success<A>
    implements EOr<A> {
        private final A a;

        public Success(A a) {
            this.a = a;
        }

        public A a() {
            return this.a;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Success)) {
                return false;
            }
            Success success = (Success)object;
            return Objects.equals(this.a, success.a);
        }

        public int hashCode() {
            return Objects.hash(this.a);
        }

        public String toString() {
            return String.valueOf(this.a);
        }
    }
}

