/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.css;

import dev.amp.validator.css.Token;
import dev.amp.validator.css.TokenType;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public final class CssTokenUtil {
    private static final Map<Integer, TokenType> KIND_TO_TOKENTYPE = new HashMap<Integer, TokenType>();
    private static final Map<String, String> REFLECT_TOKEN;

    private CssTokenUtil() {
    }

    public static TokenType getTokenType(@Nonnull com.steadystate.css.parser.Token token) {
        return KIND_TO_TOKENTYPE.get(token.kind);
    }

    public static Token copyPosTo(@Nonnull com.steadystate.css.parser.Token css3Token, @Nonnull Token other) {
        other.setCol(css3Token.beginColumn);
        other.setLine(css3Token.beginLine);
        return other;
    }

    public static String getMirror(@Nonnull com.steadystate.css.parser.Token token) {
        return REFLECT_TOKEN.get(token.toString().trim());
    }

    static {
        KIND_TO_TOKENTYPE.put(20, TokenType.NUMBER);
        KIND_TO_TOKENTYPE.put(1, TokenType.WHITESPACE);
        KIND_TO_TOKENTYPE.put(0, TokenType.EOF_TOKEN);
        KIND_TO_TOKENTYPE.put(112, TokenType.AT_KEYWORD);
        KIND_TO_TOKENTYPE.put(74, TokenType.AT_KEYWORD);
        KIND_TO_TOKENTYPE.put(75, TokenType.AT_KEYWORD);
        KIND_TO_TOKENTYPE.put(48, TokenType.CDC);
        KIND_TO_TOKENTYPE.put(47, TokenType.CDO);
        KIND_TO_TOKENTYPE.put(59, TokenType.SEMICOLON);
        KIND_TO_TOKENTYPE.put(54, TokenType.OPEN_CURLY);
        KIND_TO_TOKENTYPE.put(55, TokenType.CLOSE_CURLY);
        KIND_TO_TOKENTYPE.put(65, TokenType.OPEN_SQUARE);
        KIND_TO_TOKENTYPE.put(66, TokenType.CLOSE_SQUARE);
        KIND_TO_TOKENTYPE.put(56, TokenType.OPEN_PAREN);
        KIND_TO_TOKENTYPE.put(57, TokenType.CLOSE_PAREN);
        KIND_TO_TOKENTYPE.put(60, TokenType.COLON);
        KIND_TO_TOKENTYPE.put(70, TokenType.COMMA);
        KIND_TO_TOKENTYPE.put(113, TokenType.DELIM);
        KIND_TO_TOKENTYPE.put(61, TokenType.DELIM);
        KIND_TO_TOKENTYPE.put(67, TokenType.DELIM);
        KIND_TO_TOKENTYPE.put(63, TokenType.DELIM);
        KIND_TO_TOKENTYPE.put(58, TokenType.DELIM);
        KIND_TO_TOKENTYPE.put(69, TokenType.DELIM);
        KIND_TO_TOKENTYPE.put(68, TokenType.DELIM);
        KIND_TO_TOKENTYPE.put(64, TokenType.DELIM);
        KIND_TO_TOKENTYPE.put(71, TokenType.HASH);
        KIND_TO_TOKENTYPE.put(19, TokenType.IDENT);
        KIND_TO_TOKENTYPE.put(18, TokenType.IDENT);
        KIND_TO_TOKENTYPE.put(17, TokenType.IDENT);
        KIND_TO_TOKENTYPE.put(111, TokenType.FUNCTION_TOKEN);
        KIND_TO_TOKENTYPE.put(22, TokenType.IDENT);
        KIND_TO_TOKENTYPE.put(26, TokenType.URL);
        KIND_TO_TOKENTYPE.put(105, TokenType.URL);
        KIND_TO_TOKENTYPE.put(25, TokenType.STRING);
        KIND_TO_TOKENTYPE.put(49, TokenType.INCLUDE_MATCH);
        KIND_TO_TOKENTYPE.put(50, TokenType.DASH_MATCH);
        KIND_TO_TOKENTYPE.put(51, TokenType.PREFIX_MATCH);
        KIND_TO_TOKENTYPE.put(52, TokenType.SUFFIX_MATCH);
        KIND_TO_TOKENTYPE.put(53, TokenType.SUBSTRING_MATCH);
        REFLECT_TOKEN = new HashMap<String, String>();
        REFLECT_TOKEN.put("[", "]");
        REFLECT_TOKEN.put("(", ")");
        REFLECT_TOKEN.put("{", "}");
        REFLECT_TOKEN.put("]", "[");
        REFLECT_TOKEN.put(")", "(");
        REFLECT_TOKEN.put("}", "{");
    }
}

