/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecOverrideList;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.Unsigned;
import dev.argon.esexpr.codecs.IntCodecBase;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;

public class UnsignedIntegerCodec
extends IntCodecBase<Integer> {
    @ESExprCodecOverrideList(value={@ESExprOverrideCodec(value=int.class, requiredAnnotations={Unsigned.class}), @ESExprOverrideCodec(value=Integer.class, requiredAnnotations={Unsigned.class})})
    public static final ESExprCodec<Integer> INSTANCE = new UnsignedIntegerCodec();

    private UnsignedIntegerCodec() {
        super(BigInteger.ZERO, BigInteger.valueOf(0xFFFFFFFFL));
    }

    @Override
    @NotNull
    protected Integer fromBigInt(@NotNull BigInteger value) {
        return value.intValue();
    }

    @Override
    @NotNull
    protected BigInteger toBigInt(@NotNull Integer value) {
        return BigInteger.valueOf(Integer.toUnsignedLong(value));
    }
}

