/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import dev.argon.esexpr.Unsigned;
import java.math.BigInteger;

public class BigIntegerCodec
extends ESExprCodec<BigInteger> {
    @ESExprOverrideCodec(value=BigInteger.class, excludedAnnotations={Unsigned.class})
    @ESExprCodecTags(scalar={ESExprTag.Scalar.INT})
    public static final ESExprCodec<BigInteger> INSTANCE = new BigIntegerCodec();

    private BigIntegerCodec() {
    }

    @Override
    public boolean isEncodedEqual(BigInteger x, BigInteger y) {
        return x.equals(y);
    }

    @Override
    public final ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.INT);
    }

    @Override
    public final ESExpr encode(BigInteger value) {
        return new ESExpr.Int(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final BigInteger decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        if (!(expr instanceof ESExpr.Int)) throw new DecodeException("Expected an integer value", path);
        ESExpr.Int intVal = (ESExpr.Int)expr;
        try {
            BigInteger bigInteger = intVal.n();
            return bigInteger;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

