/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import java.util.Arrays;
import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;

public class IntArrayCodec
extends ESExprCodec<int[]> {
    @ESExprOverrideCodec(value=int[].class)
    @ESExprCodecTags(scalar={ESExprTag.Scalar.ARRAY32})
    public static final ESExprCodec<int[]> INSTANCE = new IntArrayCodec();

    private IntArrayCodec() {
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.ARRAY32);
    }

    @Override
    public boolean isEncodedEqual(int[] x, int[] y) {
        return Arrays.equals(x, y);
    }

    @Override
    public ESExpr encode(int[] value) {
        return new ESExpr.Array32(IntLists.immutable.of(value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int[] decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        ImmutableIntList b;
        if (!(expr instanceof ESExpr.Array32)) throw new DecodeException("Expected an array8 value", path);
        ESExpr.Array32 array32 = (ESExpr.Array32)expr;
        try {
            ImmutableIntList immutableIntList;
            b = immutableIntList = array32.b();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return b.toArray();
    }
}

