/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import java.math.BigInteger;

public abstract class IntCodecBase<T>
extends ESExprCodec<T> {
    private final BigInteger min;
    private final BigInteger max;

    IntCodecBase(BigInteger min, BigInteger max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public final ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.INT);
    }

    @Override
    public final ESExpr encode(T value) {
        return new ESExpr.Int(this.toBigInt(value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final T decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        if (!(expr instanceof ESExpr.Int)) throw new DecodeException("Expected an integer value", path);
        ESExpr.Int intVal = (ESExpr.Int)expr;
        try {
            BigInteger bigInteger;
            BigInteger i = bigInteger = intVal.n();
            if (i.compareTo(this.min) >= 0 && i.compareTo(this.max) <= 0) return this.fromBigInt(i);
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        throw new DecodeException("Integer value out of range", path);
    }

    abstract T fromBigInt(BigInteger var1);

    abstract BigInteger toBigInt(T var1);
}

