/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.parameters;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;

public class Parameters
implements Serializable {
    public static final Parameters EMPTY_PARAMETERS = new Parameters();
    private Map m_parameters = new HashMap();
    private boolean m_readOnly;

    public String setParameter(String name, String value2) throws IllegalStateException {
        this.checkWriteable();
        if (null == name) {
            return null;
        }
        if (null == value2) {
            return (String)this.m_parameters.remove(name);
        }
        return this.m_parameters.put(name, value2);
    }

    public void removeParameter(String name) {
        this.setParameter(name, null);
    }

    public Iterator getParameterNames() {
        return this.m_parameters.keySet().iterator();
    }

    public String[] getNames() {
        return this.m_parameters.keySet().toArray(new String[0]);
    }

    public boolean isParameter(String name) {
        return this.m_parameters.containsKey(name);
    }

    public String getParameter(String name) throws ParameterException {
        if (null == name) {
            throw new ParameterException("You cannot lookup a null parameter");
        }
        String test = (String)this.m_parameters.get(name);
        if (null == test) {
            throw new ParameterException("The parameter '" + name + "' does not contain a value");
        }
        return test;
    }

    public String getParameter(String name, String defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        String test = (String)this.m_parameters.get(name);
        if (test == null) {
            return defaultValue;
        }
        return test;
    }

    private int parseInt(String value2) throws NumberFormatException {
        if (value2.startsWith("0x")) {
            return Integer.parseInt(value2.substring(2), 16);
        }
        if (value2.startsWith("0o")) {
            return Integer.parseInt(value2.substring(2), 8);
        }
        if (value2.startsWith("0b")) {
            return Integer.parseInt(value2.substring(2), 2);
        }
        return Integer.parseInt(value2);
    }

    public int getParameterAsInteger(String name) throws ParameterException {
        try {
            return this.parseInt(this.getParameter(name));
        }
        catch (NumberFormatException e) {
            throw new ParameterException("Could not return an integer value", e);
        }
    }

    public int getParameterAsInteger(String name, int defaultValue) {
        try {
            String value2 = this.getParameter(name, null);
            if (value2 == null) {
                return defaultValue;
            }
            return this.parseInt(value2);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private long parseLong(String value2) throws NumberFormatException {
        if (value2.startsWith("0x")) {
            return Long.parseLong(value2.substring(2), 16);
        }
        if (value2.startsWith("0o")) {
            return Long.parseLong(value2.substring(2), 8);
        }
        if (value2.startsWith("0b")) {
            return Long.parseLong(value2.substring(2), 2);
        }
        return Long.parseLong(value2);
    }

    public long getParameterAsLong(String name) throws ParameterException {
        try {
            return this.parseLong(this.getParameter(name));
        }
        catch (NumberFormatException e) {
            throw new ParameterException("Could not return a long value", e);
        }
    }

    public long getParameterAsLong(String name, long defaultValue) {
        try {
            String value2 = this.getParameter(name, null);
            if (value2 == null) {
                return defaultValue;
            }
            return this.parseLong(value2);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public float getParameterAsFloat(String name) throws ParameterException {
        try {
            return Float.parseFloat(this.getParameter(name));
        }
        catch (NumberFormatException e) {
            throw new ParameterException("Could not return a float value", e);
        }
    }

    public float getParameterAsFloat(String name, float defaultValue) {
        try {
            String value2 = this.getParameter(name, null);
            if (value2 == null) {
                return defaultValue;
            }
            return Float.parseFloat(value2);
        }
        catch (NumberFormatException pe) {
            return defaultValue;
        }
    }

    public boolean getParameterAsBoolean(String name) throws ParameterException {
        String value2 = this.getParameter(name);
        if (value2.equalsIgnoreCase("true")) {
            return true;
        }
        if (value2.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ParameterException("Could not return a boolean value");
    }

    public boolean getParameterAsBoolean(String name, boolean defaultValue) {
        String value2 = this.getParameter(name, null);
        if (value2 == null) {
            return defaultValue;
        }
        if (value2.equalsIgnoreCase("true")) {
            return true;
        }
        if (value2.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    public Parameters merge(Parameters other) {
        this.checkWriteable();
        String[] names = other.getNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String value2 = null;
            try {
                value2 = other.getParameter(name);
            }
            catch (ParameterException pe) {
                value2 = null;
            }
            this.setParameter(name, value2);
        }
        return this;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof Parameters)) {
            return false;
        }
        Parameters p = (Parameters)other;
        if (this.m_readOnly != p.m_readOnly) {
            return false;
        }
        return ((Object)this.m_parameters).equals(p.m_parameters);
    }

    public int hashCode() {
        int hash2 = ((Object)this.m_parameters).hashCode();
        return hash2 >>>= this.m_readOnly ? 7 : 13;
    }

    public String toString() {
        return "Parameters[" + (this.m_readOnly ? "r/o]" : "r/w]:") + this.m_parameters;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("Context is read only and can not be modified");
        }
    }

    public static Parameters fromConfiguration(Configuration configuration) throws ConfigurationException {
        return Parameters.fromConfiguration(configuration, "parameter");
    }

    public static Parameters fromConfiguration(Configuration configuration, String elementName) throws ConfigurationException {
        if (null == configuration) {
            throw new ConfigurationException("You cannot convert to parameters with a null Configuration");
        }
        Configuration[] parameters = configuration.getChildren(elementName);
        Parameters params = new Parameters();
        for (int i = 0; i < parameters.length; ++i) {
            try {
                String name = parameters[i].getAttribute("name");
                String value2 = parameters[i].getAttribute("value");
                params.setParameter(name, value2);
                continue;
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot process Configurable", e);
            }
        }
        return params;
    }

    public static Parameters fromProperties(Properties properties) {
        Parameters parameters = new Parameters();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String key = names.nextElement().toString();
            String value2 = properties.getProperty(key);
            parameters.setParameter(key, value2);
        }
        return parameters;
    }

    public static Properties toProperties(Parameters params) {
        Properties properties = new Properties();
        String[] names = params.getNames();
        for (int i = 0; i < names.length; ++i) {
            properties.setProperty(names[i], params.getParameter(names[i], ""));
        }
        return properties;
    }

    static {
        EMPTY_PARAMETERS.makeReadOnly();
    }
}

