/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.accessibility.fo;

import java.util.Locale;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.fo.flow.PageNumberCitationLast;
import org.apache.fop.fo.flow.Wrapper;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class StructureTreeEventTrigger
extends FOEventHandler {
    private StructureTreeEventHandler structureTreeEventHandler;

    public StructureTreeEventTrigger(StructureTreeEventHandler structureTreeEventHandler) {
        this.structureTreeEventHandler = structureTreeEventHandler;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPageSequence(PageSequence pageSeq) {
        Locale locale = null;
        if (pageSeq.getLanguage() != null) {
            locale = pageSeq.getCountry() != null ? new Locale(pageSeq.getLanguage(), pageSeq.getCountry()) : new Locale(pageSeq.getLanguage());
        }
        String role = pageSeq.getCommonAccessibility().getRole();
        this.structureTreeEventHandler.startPageSequence(locale, role);
    }

    public void endPageSequence(PageSequence pageSeq) {
        this.structureTreeEventHandler.endPageSequence();
    }

    public void startPageNumber(PageNumber pagenum) {
        this.startElementWithID(pagenum);
    }

    public void endPageNumber(PageNumber pagenum) {
        this.endElement(pagenum);
    }

    public void startPageNumberCitation(PageNumberCitation pageCite) {
        this.startElementWithID(pageCite);
    }

    public void endPageNumberCitation(PageNumberCitation pageCite) {
        this.endElement(pageCite);
    }

    public void startPageNumberCitationLast(PageNumberCitationLast pageLast) {
        this.startElementWithID(pageLast);
    }

    public void endPageNumberCitationLast(PageNumberCitationLast pageLast) {
        this.endElement(pageLast);
    }

    public void startFlow(Flow fl) {
        this.startElement(fl);
    }

    public void endFlow(Flow fl) {
        this.endElement(fl);
    }

    public void startBlock(Block bl) {
        this.startElement(bl);
    }

    public void endBlock(Block bl) {
        this.endElement(bl);
    }

    public void startBlockContainer(BlockContainer blc) {
        this.startElement(blc);
    }

    public void endBlockContainer(BlockContainer blc) {
        this.endElement(blc);
    }

    public void startInline(Inline inl) {
        this.startElement(inl);
    }

    public void endInline(Inline inl) {
        this.endElement(inl);
    }

    public void startTable(Table tbl) {
        this.startElement(tbl);
    }

    public void endTable(Table tbl) {
        this.endElement(tbl);
    }

    public void startHeader(TableHeader header) {
        this.startElement(header);
    }

    public void endHeader(TableHeader header) {
        this.endElement(header);
    }

    public void startFooter(TableFooter footer) {
        this.startElement(footer);
    }

    public void endFooter(TableFooter footer) {
        this.endElement(footer);
    }

    public void startBody(TableBody body2) {
        this.startElement(body2);
    }

    public void endBody(TableBody body2) {
        this.endElement(body2);
    }

    public void startRow(TableRow tr) {
        this.startElement(tr);
    }

    public void endRow(TableRow tr) {
        this.endElement(tr);
    }

    public void startCell(TableCell tc) {
        AttributesImpl attributes = new AttributesImpl();
        int colSpan = tc.getNumberColumnsSpanned();
        if (colSpan > 1) {
            this.addNoNamespaceAttribute(attributes, "number-columns-spanned", Integer.toString(colSpan));
        }
        this.startElement(tc, attributes);
    }

    public void endCell(TableCell tc) {
        this.endElement(tc);
    }

    public void startList(ListBlock lb) {
        this.startElement(lb);
    }

    public void endList(ListBlock lb) {
        this.endElement(lb);
    }

    public void startListItem(ListItem li) {
        this.startElement(li);
    }

    public void endListItem(ListItem li) {
        this.endElement(li);
    }

    public void startListLabel(ListItemLabel listItemLabel) {
        this.startElement(listItemLabel);
    }

    public void endListLabel(ListItemLabel listItemLabel) {
        this.endElement(listItemLabel);
    }

    public void startListBody(ListItemBody listItemBody) {
        this.startElement(listItemBody);
    }

    public void endListBody(ListItemBody listItemBody) {
        this.endElement(listItemBody);
    }

    public void startStatic(StaticContent staticContent) {
        this.startElement(staticContent);
    }

    public void endStatic(StaticContent statisContent) {
        this.endElement(statisContent);
    }

    public void startLink(BasicLink basicLink) {
        this.startElementWithID(basicLink);
    }

    public void endLink(BasicLink basicLink) {
        this.endElement(basicLink);
    }

    public void image(ExternalGraphic eg) {
        this.startElementWithIDAndAltText(eg);
        this.endElement(eg);
    }

    public void startInstreamForeignObject(InstreamForeignObject ifo) {
        this.startElementWithIDAndAltText(ifo);
    }

    public void endInstreamForeignObject(InstreamForeignObject ifo) {
        this.endElement(ifo);
    }

    public void startFootnote(Footnote footnote) {
        this.startElement(footnote);
    }

    public void endFootnote(Footnote footnote) {
        this.endElement(footnote);
    }

    public void startFootnoteBody(FootnoteBody body2) {
        this.startElement(body2);
    }

    public void endFootnoteBody(FootnoteBody body2) {
        this.endElement(body2);
    }

    public void startWrapper(Wrapper wrapper) {
        this.startElement(wrapper);
    }

    public void endWrapper(Wrapper wrapper) {
        this.endElement(wrapper);
    }

    public void character(Character c) {
        this.startElementWithID(c);
        this.endElement(c);
    }

    public void characters(FOText foText) {
        this.startElementWithID(foText);
        this.endElement(foText);
    }

    private void startElement(FONode node) {
        this.startElement(node, new AttributesImpl());
    }

    private void startElementWithID(FONode node) {
        AttributesImpl attributes = new AttributesImpl();
        String localName = node.getLocalName();
        if (node instanceof CommonAccessibilityHolder) {
            this.addRole((CommonAccessibilityHolder)((Object)node), attributes);
        }
        node.setStructureTreeElement(this.structureTreeEventHandler.startReferencedNode(localName, attributes));
    }

    private void startElementWithIDAndAltText(AbstractGraphics node) {
        AttributesImpl attributes = new AttributesImpl();
        String localName = node.getLocalName();
        this.addRole(node, attributes);
        this.addAttribute(attributes, "http://xmlgraphics.apache.org/fop/extensions", "alt-text", "fox", node.getAltText());
        node.setStructureTreeElement(this.structureTreeEventHandler.startImageNode(localName, attributes));
    }

    private StructureTreeElement startElement(FONode node, AttributesImpl attributes) {
        String localName = node.getLocalName();
        if (node instanceof CommonAccessibilityHolder) {
            this.addRole((CommonAccessibilityHolder)((Object)node), attributes);
        }
        return this.structureTreeEventHandler.startNode(localName, attributes);
    }

    private void addNoNamespaceAttribute(AttributesImpl attributes, String name, String value2) {
        attributes.addAttribute("", name, name, "CDATA", value2);
    }

    private void addAttribute(AttributesImpl attributes, String namespace, String localName, String prefix, String value2) {
        assert (namespace.length() > 0 && prefix.length() > 0);
        String qualifiedName = prefix + ":" + localName;
        attributes.addAttribute(namespace, localName, qualifiedName, "CDATA", value2);
    }

    private void addRole(CommonAccessibilityHolder node, AttributesImpl attributes) {
        String role = node.getCommonAccessibility().getRole();
        if (role != null) {
            this.addNoNamespaceAttribute(attributes, "role", role);
        }
    }

    private void endElement(FONode node) {
        String localName = node.getLocalName();
        this.structureTreeEventHandler.endNode(localName);
    }
}

