/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.scripts;

import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.scripts.ScriptProcessor;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public class DefaultScriptProcessor
extends ScriptProcessor {
    private static final String[] gsubFeatures = new String[]{"ccmp", "liga", "locl"};
    private static final String[] gposFeatures = new String[]{"kern", "mark", "mkmk"};

    DefaultScriptProcessor(String script) {
        super(script);
    }

    public String[] getSubstitutionFeatures() {
        return gsubFeatures;
    }

    public ScriptContextTester getSubstitutionContextTester() {
        return null;
    }

    public String[] getPositioningFeatures() {
        return gposFeatures;
    }

    public ScriptContextTester getPositioningContextTester() {
        return null;
    }

    public GlyphSequence reorderCombiningMarks(GlyphDefinitionTable gdef, GlyphSequence gs, int[][] gpa, String script, String language2) {
        int ng = gs.getGlyphCount();
        int[] ga = gs.getGlyphArray(false);
        int nm = 0;
        for (int i = 0; i < ng; ++i) {
            int gid = ga[i];
            if (!gdef.isGlyphClass(gid, 3)) continue;
            ++nm;
        }
        if (nm > 0 && ng - nm > 0) {
            GlyphSequence.CharAssociation[] aa = gs.getAssociations(0, -1);
            int[] nga = new int[ng];
            Object npa = gpa != null ? new int[ng][] : (Object)null;
            GlyphSequence.CharAssociation[] naa = new GlyphSequence.CharAssociation[ng];
            int k = 0;
            GlyphSequence.CharAssociation ba = null;
            int bg = -1;
            int[] bpa = null;
            for (int i = 0; i < ng; ++i) {
                int gid = ga[i];
                int[] pa = gpa != null ? gpa[i] : null;
                GlyphSequence.CharAssociation ca = aa[i];
                if (gdef.isGlyphClass(gid, 3)) {
                    nga[k] = gid;
                    naa[k] = ca;
                    if (npa != null) {
                        npa[k] = pa;
                    }
                    ++k;
                    continue;
                }
                if (bg != -1) {
                    nga[k] = bg;
                    naa[k] = ba;
                    if (npa != null) {
                        npa[k] = bpa;
                    }
                    ++k;
                    bg = -1;
                    ba = null;
                    bpa = null;
                }
                if (bg != -1) continue;
                bg = gid;
                ba = ca;
                bpa = pa;
            }
            if (bg != -1) {
                nga[k] = bg;
                naa[k] = ba;
                if (npa != null) {
                    npa[k] = bpa;
                }
                ++k;
            }
            assert (k == ng);
            if (npa != null) {
                System.arraycopy(npa, 0, gpa, 0, ng);
            }
            return new GlyphSequence(gs, null, nga, null, null, naa, null);
        }
        return gs;
    }
}

