/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.UnresolvedPageNumber;
import org.apache.fop.fo.flow.PageNumberCitationLast;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.inline.AbstractPageNumberCitationLayoutManager;

public class PageNumberCitationLastLayoutManager
extends AbstractPageNumberCitationLayoutManager {
    public PageNumberCitationLastLayoutManager(PageNumberCitationLast node) {
        super(node);
        this.fobj = node;
    }

    public InlineArea get(LayoutContext context) {
        this.curArea = this.getPageNumberCitationLastInlineArea(this.parentLayoutManager);
        return this.curArea;
    }

    private InlineArea getPageNumberCitationLastInlineArea(LayoutManager parentLM) {
        TextArea text2 = null;
        int level = this.getBidiLevel();
        if (!this.getPSLM().associateLayoutManagerID(this.fobj.getRefId())) {
            text2 = new UnresolvedPageNumber(this.fobj.getRefId(), this.font, false);
            this.getPSLM().addUnresolvedArea(this.fobj.getRefId(), (Resolvable)((Object)text2));
            String str = "MMM";
            int width = this.getStringWidth(str);
            text2.setBidiLevel(level);
            text2.setIPD(width);
            this.resolved = false;
        } else {
            PageViewport page = this.getPSLM().getLastPVWithID(this.fobj.getRefId());
            String str = page.getPageNumberString();
            text2 = new TextArea();
            int width = this.getStringWidth(str);
            text2.setBidiLevel(level);
            text2.addWord(str, 0, level);
            text2.setIPD(width);
            this.resolved = true;
        }
        this.updateTextAreaTraits(text2);
        return text2;
    }
}

